﻿using System;
using System.Collections.Generic;
using dataladder.Data;
using dataladder.Matching;

namespace DataMatching.Matching
{
    public class MatchSettings
    {
        public MatchSettings()
        {
            SourcePairs = new List<MatchEngine.DataSourceIndexPair>();
            Tables = new List<ITable2CoordsMapper>();
            MaxMatchesForOneRow = 3;
            MaxMatchesPerGroup = 0;
            ClearAllAfterMatching = true;
            AllRecordsInGoupMustBeSimilar = false;
        }

        public String DataPath { get; set; }
        public String TempPath { get; set; }
        public String Name { get; set; }

        public MultipleMatchDefinitionsManager MatchDefinitionManager { get; set; }
        public List<MatchEngine.DataSourceIndexPair> SourcePairs { get; set; }
        public List<ITable2CoordsMapper> Tables { get; set; }

        public Int32 MaxMatchesForOneRow { get; set; }
        public Int32 MaxMatchesPerGroup { get; set; }
        public Boolean AllRecordsInGoupMustBeSimilar { get; set; }
        public Boolean ClearAllAfterMatching { get; set; }
        
        public OnDriveTable PairsScoresTable { get; set; }
        public OnDriveTable FinalScoresGroupsTable { get; set; }
    }
}
