﻿using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using AddressValidation.DataLayer;
using AddressValidation.DataLayer.Entities;
using DataMatch.AddressVerification;
using DataMatch.AddressVerification.Contracts;
using DataMatch.AddressVerification.Entities;
using DataMatch.AddressVerification.Enums;

namespace AddressValidationTests
{
    [TestClass]
    public class DataLayerTests
    {
        [TestMethod]
        public void TestInsertRecord()
        {
            String primaryAddress = @"Boston";
            ICassManager cassManager = CassManagerFactory.Create(CassManagerTypes.Default);
            ICassRequest cassRequest = new CassRequest(primaryAddress);
            ICassResponses responses = cassManager.GetAddressSuggestions(cassRequest);
            ICassResponse response = responses.Responses[0];

            ContactInfo contactInfo = new ContactInfo()
            {
                Address1 = response.AddressMain,
                Address2 = response.AddressSecondary,
                Country = response.Country,
                State = response.State,
                City = response.City,
                Zip = "12345",
                FirstName = "John",
                LastName = "Smith",
                Email = "john.smith@google.com",
                Phone = "+1(786)935-87-14",
                Custom1 = "Custom text 1",
                Custom2 = "Custom text 2",
                IsDuplicate = false,
                IsVerified = false
            };

            ContactDbManager.AddContact(contactInfo);

            List<ContactInfo> contacts = ContactDbManager.GetContacts();

            ContactInfo lastContact = contacts[contacts.Count - 1];

            Assert.IsTrue(String.Equals(contactInfo.Address1, lastContact.Address1));
        }
    }
}
