﻿using System;

using dataladder.Data;
using dataladder.Licensing;
using dataladder.Matching.Project;

namespace UsingTheExistingProject
{
    class Program
    {
        static void Main(string[] args)
        {
            RegistrationWrapper registrationWrapper = new RegistrationWrapper();
            registrationWrapper.CustomPathForRegistrationFile = @"D:\API\Registration\";
            DateTime expirationTime = RegistrationWrapper.ExpirationDate;
            Console.WriteLine("Expiration time: " + expirationTime);
            dataladder.Matching.ApplicationSettings.DataPath = @"D:\API\Data\";
            dataladder.Matching.ApplicationSettings.TempDataPath = @"D:\API\Temp\";

            var sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            var projectInfo = new ProjectInfo();
            projectInfo.Load(@"D:\API\Projects\ApiExampleExcel.dmeproj");
            //projectInfo.Load(@"D:\API\Projects\ApiExampleCsv.dmeproj");

            Console.WriteLine("project: \"" + projectInfo.ProjectName + "\" loaded." + $" ({sw.ElapsedMilliseconds} ms)");
            
            projectInfo.RunTransformation();
            Console.WriteLine("data transformed" + $" ({sw.ElapsedMilliseconds} ms)");
            projectInfo.MatchEngine.DoIndex();
            Console.WriteLine("indexing finished" + $" ({sw.ElapsedMilliseconds} ms)");
            projectInfo.MatchEngine.DoMatch();
            Console.WriteLine("matching finished" + $" ({sw.ElapsedMilliseconds} ms)");
            projectInfo.MatchEngine.ProcessFinalResults();
            Console.WriteLine("results processed" + $" ({sw.ElapsedMilliseconds} ms)");

            Console.WriteLine($"Groups: {projectInfo.MatchEngine.FinalScoresGroupsTable.RecordCount}");

            //Export results into DB:

            //string connectionString = @"Data Source=WNET-A15053\SQLEXPRESS;Initial Catalog=API;Integrated Security=True";
            //SqlDbHelper sqlDbHelper = new SqlDbHelper(connectionString);
            //string exportTableName = projectInfo.ProjectName + " results";
            //string schemaName = "dbo";
            //bool truncate = sqlDbHelper.TableExists(schemaName, exportTableName);
            //dataladder.Data.IReaderHelper.Export(projectInfo.MatchEngine.FinalScoresGroupsTable,
            //    sqlDbHelper,
            //    schemaName: "",
            //    tableName: exportTableName,
            //    onTableProgress: null,
            //    bulkCopy: true,
            //    truncate: truncate);
            //Console.WriteLine("groups exported");

            Console.WriteLine("Press Enter to continue . . .");
            Console.ReadLine();
        }
    }
}