﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using dataladder.Data;
using LiveSearchDemo.Entities;

namespace LiveSearchDemo.Contracts
{
    internal interface IView
    {
        String ProjectsPath { get; set; }

        Project Project { get; set; }

        Int32 BestMatchesCapacity { get; set; }

        Func<String, Boolean> IsInputDataColumn { get; set; }

        String[] SearchValues { get; set; }

        String[] InputValues { get; set; }

        InMemoryTable LiveSearchResultsTable { get; set; }

        InMemoryTable DuplicatesTable { get; set; }

        InMemoryTable InsertedTable { get; set; }

        InMemoryTable CleansedTable { get; set; }


        void BindProjectInfo();

        void BindSavedSearchValues(Dictionary<String, String> values);

        void BindSearchResults();

        void BindDuplicateCheckResults();

        void BindInsertedTable();

        void BindCleansedTable();

        void DisplayError(String errorMessage);
    }
}
