﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LiveSearchDemo
{
    public partial class SettingsForm : Form
    {
        UsingTheExistingProjectWithGUI.MainForm _mainView; 

        public SettingsForm()
        {
            InitializeComponent();
        }

        internal void Init(UsingTheExistingProjectWithGUI.MainForm main)
        {
            _mainView = main;
            pictureBoxPreview.Image = main.PictureBoxLogo.Image;

            _mainView.PictureBoxLogo.Height = _mainView.PictureBoxLogo.Image.Height;
            panel2.Height = pictureBoxPreview.Image.Height + 6;

            radioButtonLeft.Checked = true;
            /*
            if (main.PictureBoxLogo.SizeMode == PictureBoxSizeMode.CenterImage && main.PictureBoxLogo.Dock == DockStyle.None)
            {
                radioButtonCenter.Checked = true;
            }

            if (main.PictureBoxLogo.SizeMode == PictureBoxSizeMode.Normal && main.PictureBoxLogo.Dock == DockStyle.Fill)
            {
                radioButtonLeft.Checked = true;
            }
            */

            pictureBoxPreview.SizeMode = main.PictureBoxLogo.SizeMode;
            pictureBoxPreview.Dock = main.PictureBoxLogo.Dock;
        }

        private void buttonLoadImage_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog ofd = new OpenFileDialog())
            {
                ofd.Title = "Upload Image";
                ofd.Filter = "Image Files(*.BMP; *.PNG; )| *.BMP; *.PNG";

                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    try
                    {
                        pictureBoxPreview.Image = System.Drawing.Image.FromFile(ofd.FileName);
                        _mainView.PictureBoxLogo.Image = System.Drawing.Image.FromFile(ofd.FileName);

                        _mainView.PictureBoxLogo.Height = _mainView.PictureBoxLogo.Image.Height;
                        panel2.Height = pictureBoxPreview.Image.Height + 6;

                        pictureBoxPreview.SizeMode = PictureBoxSizeMode.AutoSize;

                    }
                    catch { }
                }
            }
        }

        private void radioButtonCenter_CheckedChanged(object sender, EventArgs e)
        {
            /*
            if (radioButtonCenter.Checked)
            {
                _mainView.PictureBoxLogo.SizeMode = PictureBoxSizeMode.CenterImage;
                _mainView.PictureBoxLogo.Dock = DockStyle.None;
            }

            if (radioButtonLeft.Checked)
            {
                _mainView.PictureBoxLogo.SizeMode = PictureBoxSizeMode.Normal;
                _mainView.PictureBoxLogo.Dock = DockStyle.Fill;
            }

            pictureBoxPreview.SizeMode = _mainView.PictureBoxLogo.SizeMode;
            pictureBoxPreview.Dock = _mainView.PictureBoxLogo.Dock;
            */
        }
    }
}
