﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="AddressValidationWebSample.Default" %>

<%@ Register Assembly="DevExpress.Web.v17.1, Version=17.1.9.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="CACHE-CONTROL" content="NO-CACHE" />
    <meta http-equiv="EXPIRES" content="0" />

    <title>DataMatch Enterprise API Demo
    </title>

    <link rel="shorcut icon" href="Resources/DmeLogo.ico" />

    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif
        }

        #leadGenFormPopUp {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif
        }

        td {
            padding: 10px;
        }

        table {
            border-collapse: collapse;
            /*border: 1px solid black;*/
        }

        #mainTable, #mainTable td, #mainTable th {
            /*border: 1px solid black;*/
        }

            #mainTable th {
                font-size: 20px;
                color: #333333;
                padding: 5px 5px 15px;
                border-bottom: 1px solid lightgray;
            }

            #mainTable td {
                padding: 10px;
            }

        .centered {
            margin: auto;
            padding: 1rem;
        }

        .modalBackground {
            background-color: darkgray;
            opacity: 0.5;
        }

        .autocomplete_completionListElement {
            margin: 0px !important;
            z-index: 99999 !important;
            background-color: white;
            color: windowtext;
            border: buttonshadow;
            border-width: 1px;
            border-style: solid;
            cursor: default;
            overflow: auto;
            height: auto;
            text-align: left;
            left: 0px;
            list-style-type: none;
        }

        .autocomplete_highlightedListItem {
            z-index: 99999 !important;
            color: black;
            margin-left: -30px;
            padding: 1px;
            cursor: grab;
        }
        /* AutoComplete item */
        .autocomplete_listItem {
            z-index: 99999 !important;
            color: windowtext;
            padding: 1px;
            margin-left: -30px;
            cursor: grab;
        }
    </style>
</head>

<body>
    <%--TITLE--%>

    <div style="margin: auto; overflow: auto;">
        <span style="display: block; float: left; background-color: transparent;">
            <asp:Image ID="imgDataLadder" runat="server"
                ImageUrl="\Resources\clientLogo.png" Height="100"  />
        </span>
        <span style="display: block; float: right;">
            <asp:Image ID="Image1" runat="server"
                ImageUrl="\Resources\PoweredDataLadder.png" Height="100"/>
        </span>
    </div>

    <div id="demoTitle" style="padding: 1rem; background-color: #efefef; text-align: center;">
        <asp:Label runat="server"
            Font-Size="X-Large" Font-Bold="true" ForeColor="#333333"
            Text="DataMatch Enterprise API Demo" />
    </div>

    <div>
        <form id="LeadGenerationForm" runat="server">

            <asp:ScriptManager ID="mainScriptManager" runat="server"
                EnablePageMethods="true" />

            <div style="padding: 10px;">
                <%--ADD BUTTON--%>
                <span style="margin-right: 10px">
                    <asp:Button ID="btnAddRecord" runat="server"
                        Height="35"
                        Font-Names="Segoe UI" Font-Size="Medium" Font-Bold="true"
                        BorderStyle="Solid" BorderColor="#043780"
                        ForeColor="White" BackColor="#043780"
                        Text="Insert New Record"
                        OnClick="btnOpenPopUp_Click" /></span>
                <%--RESET BUTTON--%>
                <asp:Button ID="btnReset" runat="server"
                    Height="35" Visible="false"
                    Font-Names="Segoe UI" Font-Size="Medium" Font-Bold="true"
                    BorderStyle="Solid" BorderColor="#ffcc99"
                    ForeColor="#333333" BackColor="#ffcc99"
                    Text="Reset"
                    OnClick="btnReset_Click" />
            </div>

            <%--MAIN TABLES--%>
            <div style="margin: auto; padding: 10px; background-color: floralwhite;">
                <table id="mainTable" style="width: 100%; height: 800px; table-layout: fixed">
                    <thead>
                        <tr>
                            <%--<th>Input</th>--%>
                            <%--<th>Progress</th>
                            <th colspan="2">Output</th>--%>
                        </tr>
                    </thead>
                    <tbody>
                        <%--holding table--%>
                        <tr>
                            <td style="vertical-align: top; background-color: darkseagreen;">
                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Holding"
                                        Font-Size="Medium" Font-Bold="true" ForeColor="#333333" />
                                </div>
                                <dx:ASPxGridView ID="holdingGrid" runat="server" Theme="Metropolis"
                                    Width="100%" Settings-HorizontalScrollBarMode="Auto">
                                    <SettingsPager PageSize="10" />
                                    <SettingsResizing ColumnResizeMode="Control" Visualization="Live" />
                                </dx:ASPxGridView>
                            </td>
                        </tr>
                        <%--progress panel--%>
                        <tr>
                            <td style="vertical-align: top; background-color: lightgoldenrodyellow; padding: 10px;">
                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Processes Completed"
                                        Font-Size="Medium" Font-Bold="true" ForeColor="#333333" />
                                </div>
                                <asp:Label ID="lblProgress" runat="server" />

                                <%--<asp:UpdatePanel runat="server" UpdateMode="Conditional">
                                    <ContentTemplate>
                                        <asp:TextBox ID="progressTxt" runat="server" />
                                    </ContentTemplate>
                                    <Triggers>
                                        <asp:AsyncPostBackTrigger ControlID="statusTimer" EventName="Tick" />
                                    </Triggers>
                                </asp:UpdatePanel>
                                <asp:Timer ID="statusTimer" runat="server" Interval="5000" OnTick="statusTimer_Tick"></asp:Timer>--%>
                            </td>
                        </tr>
                        <%--suppressed table--%>
                        <tr>
                            <td style="vertical-align: top; background-color: mistyrose;">
                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Suppressed"
                                        Font-Size="Medium" Font-Bold="true" ForeColor="#333333" />
                                </div>
                                <dx:ASPxGridView ID="suppressedGrid" runat="server" Theme="Metropolis"
                                    Width="100%" Settings-HorizontalScrollBarMode="Auto"
                                    OnHtmlRowPrepared="suppressedGrid_HtmlRowPrepared"
                                    >
                                    <SettingsPager PageSize="10" />
                                    <SettingsResizing ColumnResizeMode="Control" Visualization="Live" />
                                </dx:ASPxGridView>
                            </td>
                        </tr>
                        <%--master table--%>
                        <tr>
                            <td style="vertical-align: top; background-color: #043780;">
                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Master"
                                        Font-Size="Medium" Font-Bold="true" ForeColor="White" />
                                </div>
                                <dx:ASPxGridView ID="masterGrid" runat="server" Theme="Metropolis"
                                    Width="100%" Settings-HorizontalScrollBarMode="Auto"
                                    OnHtmlRowPrepared="masterGrid_HtmlRowPrepared"
                                    >
                                    <SettingsPager PageSize="10" />
                                    <SettingsResizing ColumnResizeMode="Control" Visualization="Live" />
                                </dx:ASPxGridView>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <asp:Label ID="lblHidden" runat="server" Text="" />

            <ajaxToolkit:ModalPopupExtender
                ID="ModalPopupExtender" runat="server"
                TargetControlID="lblHidden"
                PopupControlID="leadGenFormPopUp"
                BackgroundCssClass="modalBackground" />

            <%--LEAD GENERATION FORM--%>
            <div id="leadGenFormPopUp" class="centered" style="background-color: azure; width: 650px;">

                <div style="text-align: center; margin: 10px 10px 30px 10px">
                    <asp:Label runat="server"
                        Font-Size="Large" Font-Bold="true"
                        ForeColor="#333333"
                        Text="Complete All the Fields" />
                </div>

                <table style="margin: auto;">
                    <tbody>
                        <%--First/Last Name--%>
                        <tr>
                            <td style="width: 20%">
                                <asp:Label runat="server" Height="20" Text="First Name" />
                            </td>
                            <td style="width: 30%">
                                <asp:TextBox ID="firstNameTxt" runat="server" Height="20" />
                            </td>
                            <td style="width: 20%; padding-left: 30px">
                                <asp:Label runat="server" Height="20" Text="Last Name" />
                            </td>
                            <td style="width: 30%;">
                                <asp:TextBox ID="lastNameTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--Address 1--%>
                        <tr>
                            <td>
                                <asp:Label runat="server" Height="20" Text="Address 1" />
                            </td>
                            <td colspan="3">
                                <asp:TextBox ID="addressTxt" runat="server" Height="20" Width="100%" />

                                <ajaxToolkit:AutoCompleteExtender ID="autoCompleteExtender" runat="server"
                                    TargetControlID="addressTxt"
                                    ServiceMethod="SearchAddresses"
                                    MinimumPrefixLength="2"
                                    CompletionInterval="100" EnableCaching="false" CompletionSetCount="5"
                                    FirstRowSelected="true"
                                    OnClientShown="PopupShown" OnClientItemSelected="ItemSelected" />
                            </td>
                        </tr>
                        <%--Address 2--%>
                        <tr>
                            <td>
                                <asp:Label runat="server" Height="20" Text="Address 2" />
                            </td>
                            <td colspan="3">
                                <asp:TextBox ID="address2Txt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--City/State--%>
                        <tr>
                            <td>
                                <asp:Label runat="server" Height="20" Text="City" />
                            </td>
                            <td>
                                <asp:TextBox ID="cityTxt" runat="server" Height="20" />
                            </td>
                            <td style="padding-left: 50px">
                                <asp:Label runat="server" Height="20" Text="State" />
                            </td>
                            <td>
                                <asp:TextBox ID="stateTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--Zip/Phone--%>
                        <tr>
                            <td>
                                <asp:Label runat="server" Height="20" Text="Zip" />
                            </td>
                            <td>
                                <asp:TextBox ID="zipTxt" runat="server" Height="20" Text="00000" />
                            </td>
                            <td style="padding-left: 50px">
                                <asp:Label runat="server" Height="20" Text="Phone" />
                            </td>
                            <td>
                                <asp:TextBox ID="phoneTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--Email--%>
                        <tr>
                            <td>
                                <asp:Label runat="server" Height="20" Text="Email" />
                            </td>
                            <td colspan="3">
                                <asp:TextBox ID="emailTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                    </tbody>
                </table>

                <div class="centered" style="width: 300px;">
                    <table style="width: 300px;">
                        <tbody>
                            <tr>
                                <td style="width: 50%;">
                                    <asp:Button ID="insertBtn" runat="server"
                                        Width="100%" Height="50"
                                        BorderStyle="Solid"
                                        ForeColor="#333333"
                                        Font-Names="Segoe UI" Font-Size="Medium" Font-Bold="true"
                                        Text="Submit"
                                        OnClick="insertBtn_Click"
                                        UseSubmitBehavior="true" />
                                </td>
                                <td style="width: 50%;">
                                    <asp:Button ID="btnCancel" runat="server"
                                        Width="100%" Height="50"
                                        BorderStyle="Solid"
                                        ForeColor="#333333"
                                        Font-Names="Segoe UI" Font-Size="Medium" Font-Bold="true"
                                        Text="Cancel"
                                        OnClick="btnCancel_Click" />
                                </td>

                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </form>
    </div>
    <script type="text/javascript">
        function PopupShown(sender, args) {
            sender._popupBehavior._element.style.zIndex = 99999999;
        }
        function ItemSelected(sender, args) {
            var addresses = sender.get_completionList().childNodes;
            var element = sender.get_element();

            for (var i = 0; i < addresses.length; i++) {
                var address = addresses[i];

                if (address.innerHTML == element.value) {
                    var addressValues = address._value.split("|");
                    document.getElementById("addressTxt").value = addressValues[0];
                    document.getElementById("address2Txt").value = addressValues[1];
                    document.getElementById("cityTxt").value = addressValues[2];
                    document.getElementById("stateTxt").value = addressValues[3];
                }
            }
        }
    </script>
</body>
</html>
