﻿using System;

namespace DataMatch.AddressVerification.Contracts
{
    public interface ICassManager
    {
        /// <summary>
        /// Returns an array of first 5 address suggestions by incomplete primary address.
        /// </summary>
        /// <param name="cassRequest"> Contains primary address to lookup (String field ICassRequest.Query). </param>
        /// <returns> Array of entities with suggestions. Every item contains Country, City, State, etc. details. </returns>
        ICassResponses GetAddressSuggestions(ICassRequest cassRequest);

        /// <summary>
        /// Returns first 5 address suggestions by incomplete primary address as JSON.
        /// </summary>
        /// <param name="primaryAddress"> String with incomplete primary address. </param>
        /// <returns> JSON with 5 address suggestions. </returns>
        String GetAddressSuggestions(String primaryAddress);
    }
}
