﻿using dataladder.Data.DataTransformation;
using DataMatch.Project.Descriptors.DataSource;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SdkInterface
{
    public class ApiTransformation
    {
        public string ColumnName { get; set; }
        public ColumnExtraction TransformationType { get; set; }
        public bool CopyField { get; private set; }
        public bool ChangeCase { get; private set; }
        public bool UpperCase { get; private set; }
        public bool LowerCase { get; private set; }
        public string ProperCase { get; private set; }
        public bool RemoveNonPrintable { get; private set; }
        public string ReplacementNonPrintable { get; private set; }
        public string ReplacementForEmptyValues { get; private set; }
        public bool RemoveLeadingSpaces { get; private set; }
        public bool RemoveTrailingSpaces { get; private set; }
        public string CharactersToRemove { get; private set; }
        public string CharactersToReplace { get; private set; }
        public bool RemoveSpaces { get; private set; }
        public bool RemoveLetters { get; private set; }
        public bool RemoveDigits { get; private set; }
        public bool ReplaceZerosWithOs { get; private set; }
        public bool ReplaceOsWithZeros { get; private set; }
        public string Regex { get; private set; }
        public string WordSmith { get; private set; }

        public static List<ApiTransformation> ConvertToTransformations(List<ColumnTransformationSpec> list)
        {
            List<ApiTransformation> resList = new List<ApiTransformation>();
            foreach (var transformationSpecification in list)
            {
                ApiTransformation apiTransformation = ConvertToTransformation(transformationSpecification);
                resList.Add(apiTransformation);
            }
            return resList;
        }

        public static ApiTransformation ConvertToTransformation(ColumnTransformationSpec transformationSpecification)
        {
            ApiTransformation res = new ApiTransformation();

            res.ColumnName = transformationSpecification.FieldName;

            res.TransformationType = ColumnExtraction.None;
            if (Enum.TryParse<TransformationTypes>(transformationSpecification.Type, out TransformationTypes typez))
            {
                res.TransformationType = ConvertToColumnExtraction(typez);
            }

            res.CopyField = transformationSpecification. CopyField;
            res.ChangeCase = transformationSpecification. ChangeCase;
            res.UpperCase = transformationSpecification. UpperCase;
            res.LowerCase = transformationSpecification. LowerCase;
            res.ProperCase = transformationSpecification. ProperCase;
            res.RemoveNonPrintable = transformationSpecification. RemoveNonPrintableCharacters;
            res.ReplacementNonPrintable = transformationSpecification. ReplacementForNonPrintableCharacters;
            res.ReplacementForEmptyValues = transformationSpecification. ReplacementForEmptyValues;
            res.RemoveLeadingSpaces  = transformationSpecification. RemoveLeadingSpaces;
            res.RemoveTrailingSpaces  = transformationSpecification. RemoveTrailingSpaces;
            res.CharactersToRemove  = transformationSpecification. CharactersToRemove;
            res.CharactersToReplace = transformationSpecification. CharactersToReplace;
            res.RemoveSpaces = transformationSpecification. RemoveSpaces;
            res.RemoveLetters = transformationSpecification. RemoveLetters;
            res.RemoveDigits  = transformationSpecification. RemoveDigits;
            res.ReplaceZerosWithOs = transformationSpecification. ReplaceZerosWithOs;
            res.ReplaceOsWithZeros  = transformationSpecification. ReplaceOsWithZeros;
            res.Regex = transformationSpecification. Regex;
            res.WordSmith = transformationSpecification. WordSmith;

            return res;
        }

        private static ColumnExtraction ConvertToColumnExtraction(TransformationTypes typez)
        {

            ColumnExtraction type;
            switch (typez)
            {
                case TransformationTypes.Address:
                    type = ColumnExtraction.Address;
                    break;
                case TransformationTypes.FirstName:
                    type = ColumnExtraction.FirstName;
                    break;
                case TransformationTypes.FullName:
                    type = ColumnExtraction.FullName;
                    break;
                case TransformationTypes.VCityName:
                    type = ColumnExtraction.VCityName;
                    break;
                case TransformationTypes.VCompanyName:
                    type = ColumnExtraction.VCompanyName;
                    break;
                case TransformationTypes.VCountry:
                    type = ColumnExtraction.VCountry;
                    break;
                case TransformationTypes.VPostalCode:
                    type = ColumnExtraction.VPostalCode;
                    break;
                case TransformationTypes.VPrimaryAddress:
                    type = ColumnExtraction.VPrimaryAddress;
                    break;
                case TransformationTypes.VSecondaryAddress:
                    type = ColumnExtraction.VSecondaryAddress;
                    break;
                case TransformationTypes.VStateName:
                    type = ColumnExtraction.VStateName;
                    break;
                case TransformationTypes.VUrbanization:
                    type = ColumnExtraction.VUrbanization;
                    break;
                case TransformationTypes.VZipCode:
                    type = ColumnExtraction.VZipCode;
                    break;
                case TransformationTypes.Zip:
                    type = ColumnExtraction.Zip;
                    break;
                default:
                    type = ColumnExtraction.None;
                    break;
            }

            return type;
        }


        internal static TransformationTypes ConvertFromColumnExtraction(ColumnExtraction apiTransformation)
        {
            TransformationTypes type;
            switch (apiTransformation)
            {
                case ColumnExtraction.Address:
                    type = TransformationTypes.Address;
                    break;
                case ColumnExtraction.FirstName:
                    type = TransformationTypes.FirstName;
                    break;
                case ColumnExtraction.FullName:
                    type = TransformationTypes.FullName;
                    break;
                case ColumnExtraction.VCityName:
                    type = TransformationTypes.VCityName;
                    break;
                case ColumnExtraction.VCompanyName:
                    type = TransformationTypes.VCompanyName;
                    break;
                case ColumnExtraction.VCountry:
                    type = TransformationTypes.VCountry;
                    break;
                case ColumnExtraction.VPostalCode:
                    type = TransformationTypes.VPostalCode;
                    break;
                case ColumnExtraction.VPrimaryAddress:
                    type = TransformationTypes.VPrimaryAddress;
                    break;
                case ColumnExtraction.VSecondaryAddress:
                    type = TransformationTypes.VSecondaryAddress;
                    break;
                case ColumnExtraction.VStateName:
                    type = TransformationTypes.VStateName;
                    break;
                case ColumnExtraction.VUrbanization:
                    type = TransformationTypes.VUrbanization;
                    break;
                case ColumnExtraction.VZipCode:
                    type = TransformationTypes.VZipCode;
                    break;
                case ColumnExtraction.Zip:
                    type = TransformationTypes.Zip;
                    break;
                default:
                    type = TransformationTypes.None;
                    break;
            }

            return type;
        }

    }

    public enum ColumnExtraction
    {
        None,
        FullName,
        FirstName,
        Address,
        Zip,
        VCompanyName,
        VPrimaryAddress,
        VSecondaryAddress,
        VCityName,
        VStateName,
        VZipCode,
        VUrbanization,
        VCountry,
        VPostalCode
    }
}
