﻿using System;

using dataladder.Data;
using dataladder.Licensing;
using dataladder.Matching.Project;

namespace UsingTheExistingProject
{
    class Program
    {
        #region Fields


        #endregion

        static void Main(string[] args)
        {
            RegistrationWrapper registrationWrapper = new RegistrationWrapper();
            registrationWrapper.CustomPathForRegistrationFile = @"C:\enterprise API\registration1\";
            DateTime expirationTime = RegistrationWrapper.ExpirationDate;
            Console.WriteLine("Expiration time: " + expirationTime);
            dataladder.Matching.ApplicationSettings.DataPath = @"e:\enterprise\data\";
            dataladder.Matching.ApplicationSettings.TempDataPath = @"e:\enterprise\temp\Data Ladder";
            String programDataPath = System.Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData);
            String dataMatchCommonFolder = "DataMatch Enterprise";
            String dataMatchCommonFolderFullPath = System.IO.Path.Combine(programDataPath, dataMatchCommonFolder) + @"\";
            //dataladder.App.Paths.SetCommonDataPath(dataMatchCommonFolderFullPath);
            ProjectInfo projectInfo = new ProjectInfo();
            //projectInfo.Load(@"C:\Users\dule\Documents\DataMatch Enterprise\projects\test sql.dmeproj");
            projectInfo.Load(@"C:\Users\pavel.demidov\Documents\DataMatch Enterprise\projects\ApiExample.dmeproj");

            Console.WriteLine("project: \"" + projectInfo.ProjectName + "\" loaded.");

            #region changing the user credentials

            //DataSourceInfo dataSourceInfo = projectInfo[0];
            //ReaderConfiguration readerConfiguration = dataSourceInfo.Reader.GetConfiguration();
            //readerConfiguration.ConfigurationString = @"Data Source=DULE-I7\SQL2008;Initial Catalog=DataMatch;Persist Security Info=True;User ID=sa;Password=mnogosmojaci";
            //dataSourceInfo.Reader.SetConfiguration(readerConfiguration);
            //// the next line is probably not the most elegant one...
            //dataSourceInfo.Refresh(projectInfo.DataPath, System.IO.Path.Combine(projectInfo.DataPath, "uncomplete"), onTableCopyProgress: null, synchronizationContext: null);
            //dataSourceInfo.CreateDiagram();

            #endregion


            projectInfo.RunTransformation();
            Console.WriteLine("data transformed");
            projectInfo.MatchEngine.DoIndex();
            Console.WriteLine("indexing finished");
            projectInfo.MatchEngine.DoMatch();
            Console.WriteLine("matching finished");
            projectInfo.MatchEngine.ProcessFinalResults();
            Console.WriteLine("results processed");

            //ReaderConfiguration readerConfiguration = dataSourceInfo.Reader.GetConfiguration();
            string connectionString = @"Data Source=WNET-A15053\SQLEXPRESS;Initial Catalog=API;Integrated Security=True";
            SqlDbHelper sqlDbHelper = new SqlDbHelper(connectionString);
            string exportTableName = projectInfo.ProjectName + " results";
            string schemaName = "dbo";
            bool truncate = sqlDbHelper.TableExists(schemaName, exportTableName);
            dataladder.Data.IReaderHelper.Export(projectInfo.MatchEngine.FinalScoresGroupsTable,
                sqlDbHelper,
                schemaName: "",
                tableName: exportTableName,
                onTableProgress: null,
                bulkCopy: true,
                truncate: truncate);
            Console.WriteLine("groups exported");
            Console.WriteLine("Press Enter to continue . . .");
            Console.ReadLine();
        }
    }
}