﻿using System.Data;
using System.Collections.Generic;
using System;
using System.Text;
using System.Threading;
using System.IO;

using dataladder.Data;
using dataladder.Matching.Indexing;
using dataladder.Licensing;
using dataladder.Matching.Project;
using dataladder.Data.DataTransformation;
using dataladder.XtraGridHelper;

namespace dataladder.Matching
{
  public class EngineWrapper : Object, IDisposable
  {
    #region Enums

    public enum AddWeightToFirstLetterActions { Project, On, Off };

    #endregion

    #region Fields

    string projectsPath;
    string appDataPath;
    string appTempDataPath;
    static string importedDataPath = Directory.GetCurrentDirectory() + @"\data";
    static string tempDataPath = Directory.GetCurrentDirectory() + @"\temp data";
    static string resultsDataPath = Directory.GetCurrentDirectory() + @"\results";
    static string finalResultsFileName = System.IO.Path.Combine(resultsDataPath, "final results.txt");
    static string transformedDataSourceAFileName = System.IO.Path.Combine(resultsDataPath, "transformed data source A.txt");

    //string connectionString = @"Data Source=DULE-I7\SQL2008;Initial Catalog=snapon;Integrated Security=True";
    //string connectionString = @"USER ID=SYSTEM;DATA SOURCE=localhost;PERSIST SECURITY INFO=True;PASSWORD=brbabrba";
    //string connectionString = @"USER ID=SYSTEM;DATA SOURCE=192.168.56.1;PERSIST SECURITY INFO=True;PASSWORD=brbabrba";
    string projectFileName;

    string dataSourceNameSingleRow = "single row table";

    OnDriveTable singleRowTable = null;
    //OnDriveTable importedTableB = null;
    //OnDriveTable importedLogTable = null;

    DataSourceInfo dataSourceInfoSearchRecord;
    //DataSourceInfo dataSourceInfoLog;

    ProjectInfo projectInfo;
    MatchEngine matchEngine;

    List<int> cachedDatasetIndexes = new List<int>();

    DateTime loadTime = DateTime.MinValue;

    OnDriveTable resultsTable;
    const int firstCol = 11; // eliminating the first columns which are not important in this application
    //const int firstCol = 0;

    //const string noAction = "X";
    const string singleRowOriginal = "O";

    public string[] MatchingFieldNames;

    //public string[] TableFieldNames = { "SHOPNAME", "ADDR1", "ADDR2", "CITY", "STATE", "ZIP" };

    string actionFieldName = "ACTION";
    //string lastUpdateFieldName = "lastupdate";

    #endregion

    #region Constructors

    public EngineWrapper(string projectFileName)
    {
      dataladder.IO.IOHelper.CreateDirectoryIfNotExist(importedDataPath);
      dataladder.IO.IOHelper.CreateDirectoryIfNotExist(tempDataPath);
      dataladder.IO.IOHelper.CreateDirectoryIfNotExist(resultsDataPath);
      IniParser parser = new IniParser("configuration.ini");
      this.projectFileName = projectFileName;
      //string connectionString = @"USER ID=SYSTEM;DATA SOURCE=192.168.56.1;PERSIST SECURITY INFO=True;PASSWORD=brbabrba";
      projectsPath = parser.GetSetting("AppSettings", "projectsPath");
      appDataPath = parser.GetSetting("AppSettings", "dataPath");
      appTempDataPath = parser.GetSetting("AppSettings", "tempDataPath");
      string pathForRegistrationFile = parser.GetSetting("AppSettings", "pathForRegistrationFile");
      //dataSourceNameSingleRow += tableName;
      RegistrationWrapper registrationWrapper = new RegistrationWrapper();
      registrationWrapper.CustomPathForRegistrationFile = pathForRegistrationFile;
      DateTime expirationTime = RegistrationWrapper.ExpirationDate;
      removeRemainedFiles();
      loadData();
    }

    #endregion

    #region Properties and Fields

    public string TableName;

    private int dataSourceCount = 0;

    public int DataSourceCount { get { return dataSourceCount; } }

    bool searchInProgress = false;
    public bool SearchInProgress { get { return searchInProgress; } }

    #endregion

    #region Methods

    /*
    /// <summary>
    /// for now it assumes all fields are text type
    /// </summary>
    /// <param name="hash"></param>
    /// <param name="tableName"></param>
    /// <param name="values"></param>
    /// <param name="fieldNames"></param>
    /// <param name="error"></param>
    /// <returns></returns>
    public bool InsertRecord(string tableName, string[] values, out string error)
    {
      bool result = false;
      error = "";
      try
      {
        StringBuilder sb = new StringBuilder();
        sb.Append("insert into ");
        sb.AppendLine(tableName);
        sb.AppendLine("(");
        for (int i = 0; i < TableFieldNames.Length; i++)
        {
          sb.Append(TableFieldNames[i]);
          if (i < TableFieldNames.Length - 1)
          {
            sb.AppendLine(",");
          }
          else
          {
            sb.AppendLine("");
          }
        }
        sb.AppendLine(")");
        sb.AppendLine("values");
        sb.AppendLine("(");
        for (int i = 0; i < TableFieldNames.Length; i++)
        {
          sb.Append("'");
          sb.Append(values[i]);
          sb.Append("'");
          if (i < TableFieldNames.Length - 1)
          {
            sb.AppendLine(",");
          }
          else
          {
            sb.AppendLine("");
          }
        }
        sb.AppendLine(")");
        executeCmd(sb.ToString());
      }
      catch (Exception ex)
      {
        error = ex.Message;
      }
      return result;
    }

    private void inserRecord(string loc,
                             string routeNum,
                             string shopname,
                             string addr1,
                             string addr2,
                             string city,
                             string state,
                             string zip,
                             string tele)
    {
      string cmd =
        "insert into midatlanticregion (LOC, ROUTENUM, SHOPNAME, ADDR1, ADDR2, CITY, STATE, ZIP, TELE) values (" +
        "'" + loc.Trim() + "', " +
        "'" + routeNum.Trim() + "', " +
        "'" + shopname.Trim() + "', " +
        "'" + addr1.Trim() + "', " +
        "'" + addr2.Trim() + "', " +
        "'" + city.Trim() + "', " +
        "'" + state.Trim() + "', " +
        "'" + zip.Trim() + "', " +
        "'" + tele.Trim() + "')";
      executeCmd(cmd);
    }
    */

    /*
    public bool UpdateRecord(string tableName, string[] values, string id, out string error)
    {
      bool result = false;
      error = "";
      try
      {
        StringBuilder sb = new StringBuilder();
        sb.Append("update ");
        sb.AppendLine(tableName);
        sb.Append(" set ");
        for (int i = 0; i < TableFieldNames.Length; i++)
        {
          sb.Append(TableFieldNames[i]);
          sb.Append(" = '");
          sb.Append(values[i]);
          sb.Append("'");
          if (i < TableFieldNames.Length - 1)
          {
            sb.AppendLine(",");
          }
          else
          {
            sb.AppendLine("");
          }
        }
        sb.Append("where " + pKfield + " = ");
        sb.AppendLine(id);
        executeCmd(sb.ToString());
      }
      catch (Exception ex)
      {
        error = ex.Message;
      }
      return result;
    }

    public bool DeleteRecord(string tableName, string id, out string error)
    {
      bool result = false;
      error = "";
      try
      {
        StringBuilder sb = new StringBuilder();
        sb.Append("delete from ");
        sb.AppendLine(tableName);
        sb.Append("where " + pKfield + " = ");
        sb.AppendLine(id);
        executeCmd(sb.ToString());
      }
      catch (Exception ex)
      {
        error = ex.Message;
      }
      return result;
    }

    private void executeCmd(string cmd)
    {
      OracleDbHelper oracleDbHelper = new OracleDbHelper(connectionString);
      oracleDbHelper.Connect();
      oracleDbHelper.ExecuteCmd(cmd);
      oracleDbHelper.Disconnect();
    }

    //static OnDriveTable getImportedTableFromSQL(string connectionString, string cmd, string dataSourceName)
    //{
    //  SqlDbHelper reader = new SqlDbHelper(connectionString);
    //  ReaderConfiguration readerConfiguration = reader.GetConfiguration();
    //  readerConfiguration.SelectCmd = cmd;
    //  reader.SetConfiguration(readerConfiguration);
    //  reader.ReadTable(readerConfiguration, true);
    //  OnDriveTable result = ReaderToVariableTableConvertor.Copy(reader, importedDataPath, dataSourceName);
    //  return result;
    //}

    static OnDriveTable getImportedTableFromOracle(string connectionString, string cmd, string dataSourceName)
    {
      SqlDbHelper sqlDbHelper = new SqlDbHelper();
      OracleDbHelper oracleDbHelper = new OracleDbHelper(connectionString);
      ReaderConfiguration readerConfiguration = oracleDbHelper.GetConfiguration();
      readerConfiguration.SelectCmd = cmd;
      oracleDbHelper.SetConfiguration(readerConfiguration);
      oracleDbHelper.ReadTable(readerConfiguration, true);
      OnDriveTable result = ReaderToVariableTableConvertor.Copy(oracleDbHelper, importedDataPath, dataSourceName);
      return result;
    }
    */

    private static void removeRemainedFiles()
    {
      dataladder.IO.IOHelper.RemoveAllFiles(importedDataPath);
      dataladder.IO.IOHelper.RemoveAllFiles(tempDataPath);
      dataladder.IO.IOHelper.RemoveAllFiles(resultsDataPath);
    }

    //---------------------------

    //private string getValue(int rowIndex, string fieldName)
    //{
    //  string result;
    //  object obj = resultsTable.GetData(rowIndex, fieldName);
    //  if (obj != DBNull.Value)
    //  {
    //    result = obj.ToString();
    //  }
    //  else
    //  {
    //    result = "";
    //  }
    //  return result; ;
    //}

    public OnDriveTable FindMatches(string[] values,
                                    int records,
                                    AddWeightToFirstLetterActions addWeightToFirstLetterAction)
    {
      while (searchInProgress) // just in case...
      {
        Thread.Sleep(10);
      }
      searchInProgress = true;
      try
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();

        MultipleMatchDefinitionsManager multipleMatchDefinitionsManager = matchEngine.MultipleMatchDefinitionsManager;
        for (int i = 0; i < multipleMatchDefinitionsManager.Count; i++)
        {
          MatchDefinitionsList matchDefinitionsList = multipleMatchDefinitionsManager[i];
          for (int ii = 0; ii < matchDefinitionsList.Count; ii++)
          {
            MatchDefinitionSingle matchDefinitionSingle = matchDefinitionsList[ii];
            if (addWeightToFirstLetterAction == AddWeightToFirstLetterActions.On)
            {
              matchDefinitionSingle.AddWeightToFirstLetter = true; 
            }
            else if (addWeightToFirstLetterAction == AddWeightToFirstLetterActions.Off)
            {
              matchDefinitionSingle.AddWeightToFirstLetter = false;
            }
          }
        }

        dataSourceInfoSearchRecord.InputTable.MakeWritable();
        for (int i = 0; i < values.Length; i++)
        {
          dataSourceInfoSearchRecord.InputTable.SetData(values[i], 0, MatchingFieldNames[i]);
        }
        dataSourceInfoSearchRecord.InputTable.MakeReadOnlyShareable();
        dataSourceInfoSearchRecord.CreateDiagram();
        dataSourceInfoSearchRecord.RunTransformation();
        matchEngine.ReindexSingleDataSource(1);
        matchEngine.LoadAllInMemory = true;
        matchEngine.DoMatch(records, clearAllAfterMatching: false);
        matchEngine.ProcessFinalResults(clearAllAfterMatching: false);
        unifyResults(matchEngine.FinalScoresGroupsFilteredTable);

        stopwatch.Stop();
      }
      finally
      {
        searchInProgress = false;
      }
      return resultsTable;
    }

    private MatchEngine initializeMatchingEngine()
    {
      dataladder.Matching.ApplicationSettings.DataPath = appDataPath + @"\";
      dataladder.Matching.ApplicationSettings.TempDataPath = appTempDataPath + @"\";
      ProjectInfo projectInfo = new ProjectInfo();
      projectInfo.Load(projectFileName);
      this.dataSourceCount = projectInfo.DataSourceCount;
      DataSourceInfo originalDataSourceInfo = projectInfo[0];
      TableName = originalDataSourceInfo.Name;
      //originalDataSourceInfo.Refresh(projectInfo.DataPath, onTableCopyProgress: null); tmp mark 1 // removed...
      originalDataSourceInfo.CreateDiagram();
      originalDataSourceInfo.RunTransformation();
      dataSourceInfoSearchRecord = new DataSourceInfo(null);
      //dataSourceInfoLog = new DataSourceInfo(null);

      if (singleRowTable != null)
      {
        singleRowTable.Dispose();
      }
      singleRowTable = createSingleRowTableAndDetermineFieldNames(projectInfo);
      for (int colIndex = 0; colIndex < MatchingFieldNames.Length; colIndex++)
      {
        string fieldName = MatchingFieldNames[colIndex];
        singleRowTable.SetData("zzzzzzzzz", 0, fieldName);
      }
      singleRowTable.SetData(singleRowOriginal, 0, actionFieldName);

      dataSourceInfoSearchRecord.InputTable = singleRowTable;

      //dataSourceInfoLog.InputTable = importedLogTable;

      projectInfo.Add(dataSourceInfoSearchRecord);
      //projectInfo.Add(dataSourceInfoLog);

      // copying the data transformation rules to the log records
      dataSourceInfoSearchRecord.ColumnTransformationList.Copy(originalDataSourceInfo.ColumnTransformationList);

      MatchDefinitionBuilder matchDefinitionBuilder = projectInfo.MatchDefinitionBuilder;

      // engine is prepared to support multiple match definitions, here we work only with one
      MultipleMatchDefinitionsManager multipleMatchDefinitionsManager = matchDefinitionBuilder.MultipleMatchDefinitionsManager;

      for (int i = 0; i < multipleMatchDefinitionsManager.Count; i++)
      {
        MatchDefinitionsList matchDefinitionsList = multipleMatchDefinitionsManager[i];
        for (int ii = 0; ii < matchDefinitionsList.Count; ii++)
        {
          MatchDefinitionSingle matchDefinitionSingle = matchDefinitionsList[ii];
          bool found;
          string fieldName = matchDefinitionSingle.GetMappedFieldName(TableName, out found);
          matchDefinitionSingle.MapField(dataSourceNameSingleRow, fieldName);
        }
      }

      // adding the action field to the project
      //mapLogField(projectInfo, lastUpdateFieldName);
      //mapLogField(projectInfo, actionFieldName);
      projectInfo.MatchDefinitionBuilder.AvailableFields.Refresh();

      //groupFields();

      // initializing match engine
      //MatchEngine matchEngine = new MatchEngine(multipleMatchDefinitionsManager, tempDataPath, resultsDataPath);
      MatchEngine matchEngine = projectInfo.MatchEngine;
      dataSourceInfoSearchRecord.InputTable.MakeReadOnlyShareable();
      dataSourceInfoSearchRecord.CreateDiagram();
      dataSourceInfoSearchRecord.RunTransformation();
      matchEngine.Add(dataSourceNameSingleRow, dataSourceInfoSearchRecord.TransformedValuesTable);

      //dataSourceInfoLog.CreateDiagram();
      //dataSourceInfoLog.RunTransformation();

      matchDefinitionBuilder.AvailableFields.InitialMapping();
      matchEngine.ClearPairToMatchList(); // they are loaded with the project...
      matchEngine.DoIndex();
      matchEngine.AddPairToMatchList(1, 0); // to find matches between data sources A and B
      //matchEngine.AddPairToMatchList(1, 2); // to find matches between data sources B and C
      cachedDatasetIndexes.Clear();
      cachedDatasetIndexes.Add(0);

      matchEngine.SetCachedDataSources(cachedDatasetIndexes);

      matchEngine.LoadAllInMemory = true;
      matchEngine.DoMatch(clearAllAfterMatching: false);
      matchEngine.ProcessFinalResults(clearAllAfterMatching: false);

      return matchEngine;
    }

    /*
    private void mapLogField(ProjectInfo projectInfo, string fieldName)
    {
      projectInfo.MatchDefinitionBuilder.AvailableFields.EnsureLastRowIsEmptyIfNeeded();
      int lastIndex = projectInfo.MatchDefinitionBuilder.AvailableFields.MappedFieldsRowList.Count - 1;
      MappedFieldsRow lastMappedFieldsRow = projectInfo.MatchDefinitionBuilder.AvailableFields.MappedFieldsRowList[lastIndex];
      FieldMapInfo fieldMapInfo = new FieldMapInfo(1);
      fieldMapInfo.FieldName = fieldName;
      lastMappedFieldsRow[dataSourceNameSingleRow] = fieldMapInfo;
      fieldMapInfo = new FieldMapInfo(2);
      fieldMapInfo.FieldName = fieldName;
      lastMappedFieldsRow[dataSourceNameLog] = fieldMapInfo;
      lastMappedFieldsRow.Include = true;
    }
    */

    private OnDriveTable createSingleRowTableAndDetermineFieldNames(ProjectInfo projectInfo)
    {
      OnDriveTable result = new OnDriveTable(importedDataPath, dataSourceNameSingleRow, toDeleteExisting: true);
      DataSourceInfo originalDataSourceInfo = projectInfo[0];
      string tableName = projectInfo[0].Name;
      TransformationDiagram transformationDiagram = originalDataSourceInfo.DiagramGenerator.DiagramVariableTableHelper.FirstTransformationDiagram;
      List<string> tmp = new List<string>();
      for (int i = 0; i < projectInfo.MatchDefinitionBuilder.MultipleMatchDefinitionsManager.Count; i++)
      {
        List<MatchDefinitionMappedToField> matchDefinitionMappedToFieldList = projectInfo.MatchDefinitionBuilder.MultipleMatchDefinitionsManager[i].DetermineFieldsToIndex(projectInfo[0].Name, projectInfo[0].TransformedValuesTable);
        int fieldsCount = matchDefinitionMappedToFieldList.Count;
        for (int ii = 0; ii < fieldsCount; ii++)
        {
          MatchDefinitionMappedToField matchDefinitionMappedToField = matchDefinitionMappedToFieldList[ii];
          string fieldName = matchDefinitionMappedToField.FieldName;
          DataFlow output = transformationDiagram.Outputs[fieldName];
          if (output != null)
          {
            for (int iii = 0; iii < transformationDiagram.Inputs.Count; iii++)
            {
              DataFlow input = transformationDiagram.Inputs[iii];
              if ((output.IsAfter(input)) | (input == output))
              {
                if (!tmp.Contains(input.Name))
                {
                  tmp.Add(input.Name);
                  result.AddField(input.Name, typeof(string));
                }
              }
            }
          }
        }
      }
      //result.AddField(lastUpdateFieldName, typeof(DateTime));
      result.AddField(actionFieldName, typeof(string));
      MatchingFieldNames = tmp.ToArray();
      return result;
    }

    private void unifyResults(ITable2CoordsMapper combinedResults)
    {
      if (resultsTable != null)
      {
        resultsTable.ToDeleteFilesAfterClosing = true;
        resultsTable.Dispose();
      }
      resultsTable = new OnDriveTable(importedDataPath, this.matchEngine.Name + " results", toDeleteExisting: true);
      int count = combinedResults.ColumnCount - 2 - firstCol;
      for (int colIndex = firstCol; colIndex < combinedResults.ColumnCount; colIndex++) // without action and last update fields
      {
        string fieldName = combinedResults.GetColumnName(colIndex);
        if ((fieldName == actionFieldName))
        {
          continue;
        }
        resultsTable.AddField(fieldName);
      }
      //string id;
      //string action;
      /*
      Dictionary<string, string> logRecords = new Dictionary<string, string>();
      for (int rowIndex = 0; rowIndex < dataSourceInfoLog.InputTable.RecordCount; rowIndex++) // record 0 is the lookup record itself...
      {
        id = dataSourceInfoLog.InputTable.GetData(rowIndex, pKfield).ToString();
        action = (string)dataSourceInfoLog.InputTable.GetData(rowIndex, actionFieldName);
        logRecords.Add(id, action);
      }
      */
      for (int rowIndex = 0; rowIndex < combinedResults.RecordCount; rowIndex++)
      {
        //id = combinedResults.GetData(rowIndex, pKfield).ToString().Trim();
        //action = combinedResults.GetData(rowIndex, actionFieldName).ToString();
        int dataSourceIndex = (int)combinedResults.GetData(rowIndex, (int)MatchEngine.PreviewFinalResultsStaticFields.DataSource);
        //if (action == singleRowOriginal) // this is the lookup record itself...
        if (dataSourceIndex == 1)
        {
          continue;
        }
        //if (!string.IsNullOrEmpty(action)) // for log records
        //{
        //  if (action == "D") // record is from log, record deleted, ignore it...
        //  {
        //    continue;
        //  }
        //  else
        //  {
        //    copyResultRecord(combinedResults, rowIndex);
        //  }
        //}
        //else // not a log record
        {
          //id = combinedResults.GetData(rowIndex, pKfield).ToString();
          //if (logRecords.TryGetValue(id, out action)) // original record, changed ignore it...
          //{
          //  continue;
          //}
          //else
          {
            copyResultRecord(combinedResults, rowIndex);
          }
        }
      }
    }

    //    private void unifyMidAtlanticResults(ITable2CoordsMapper combinedResults)
    //    {
    //      if (resultsTable != null)
    //      {
    //        resultsTable.ToDeleteFilesAfterClosing = true;
    //        resultsTable.Dispose();
    //      }
    //      resultsTable = new OnDriveTable(importedDataPath, "results", toDeleteExisting: true);
    //      for (int colIndex = firstCol; colIndex < combinedResults.ColumnCount - 2; colIndex++) // without action and last update fields
    //      {
    //        resultsTable.AddField(combinedResults.GetColumnName(colIndex));
    //      }
    //      for (int rowIndex = 0; rowIndex < combinedResults.RecordCount; rowIndex++)
    //      {
    //        int dataSourceIndex = (int)combinedResults.GetData(rowIndex, (int)MatchEngine.PreviewFinalResultsStaticFields.DataSource);
    //        if (dataSourceIndex == 0) // this is the lookup record itself...
    //        {
    //          continue;
    //        }
    //        copyMidAtlanticRecord(combinedResults, rowIndex);
    //      }
    //    }

    private void copyResultRecord(ITable2CoordsMapper combinedResults, int rowIndex)
    {
      int newRowIndex = resultsTable.RecordCount;
      for (int colIndex = firstCol; colIndex < combinedResults.ColumnCount - 2; colIndex++) // without action and last update fields
      {
        object obj = combinedResults.GetData(rowIndex, colIndex);
        resultsTable.SetData(obj, newRowIndex, colIndex - firstCol);
      }
    }

    private void loadData()
    {
      System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
      stopwatch.Start();

      projectInfo = new ProjectInfo();
      if (matchEngine != null)
      {
        matchEngine.Dispose();
        matchEngine = null;
      }
      //string cmd;
      //// importing SQL table into our internal tables
      //cmd = "select " + TableName + ".*, '" + noAction + "' as Action from " + TableName;
      //// cmd += " where rownum < 2";

      loadTime = DateTime.Now;
      //importedTableB = getImportedTableFromOracle(connectionString, cmd, dataSourceNameLog);
      //importedLogTable = importLogTable();

      matchEngine = initializeMatchingEngine();
      stopwatch.Stop();
    }

    //private void groupFields()
    //{
    //  MatchDefinitionsList matchDefinitionsList = this.projectInfo.MatchDefinitionBuilder.MultipleMatchDefinitionsManager[0];
    //  for (int i = 0; i < matchDefinitionsList.Count; i++)
    //  {
    //    MatchDefinitionSingle matchDefinitionSingle = matchDefinitionsList[i];
    //    if (false) // for now...
    //    {
    //      matchDefinitionSingle.GroupId = 0;
    //      matchDefinitionSingle.GroupLevel = 0.60f;
    //      matchDefinitionSingle.MaxEmptyWeightBelow = 200;
    //      matchDefinitionSingle.MaxMismatchWeightBelow = 200;
    //      matchDefinitionSingle.MaxTotalWeightBelow = 200;
    //    }
    //    else
    //    {
    //      matchDefinitionSingle.GroupId = -1;
    //    }
    //  }
    //}

    /*
    private OnDriveTable importLogTable()
    {
      string cmd = "select l.* from " + TableName + "log l " +
                   "right join (select " + pKfield + ", max(lastupdate) as lastupdate from " + TableName + "log group by " + pKfield + ") l2 on l." + pKfield + " = l2." + pKfield + " and l.lastupdate = l2.lastupdate " +
                   "where l.lastupdate > " + OracleDbHelper.DateTimeToString(loadTime);
      OnDriveTable result = getImportedTableFromOracle(connectionString, cmd, dataSourceNameLog);
      return result;
    }
    */

    #endregion

    #region IDisposable members

    public void Dispose()
    {
      if (singleRowTable != null)
      {
        singleRowTable.Dispose();
        singleRowTable = null;
      }

      //if (importedLogTable != null)
      //{
      //  importedLogTable.Dispose();
      //  importedLogTable = null;
      //}
      //if (importedTableB != null)
      //{
      //  importedTableB.Dispose();
      //  importedTableB = null;
      //}
      this.matchEngine.Dispose();
    }

    #endregion
  }
}
