﻿using System.Data;
using System.Collections.Generic;
using System;
using System.Text;
using System.Threading;
using System.IO;
using System.Runtime.InteropServices;
using dataladder.AddressVerification;
using dataladder.Data;
using dataladder.Matching;
using dataladder.Matching.Indexing;
using dataladder.Licensing;
using dataladder.Matching.Project;
using dataladder.Data.DataTransformation;
using dataladder.XtraGridHelper;
using DataMatch.Data.Enums;

namespace SampleServiceNamespace
{
    public class EngineWrapper : Object, IDisposable
    {
        #region Fields

        public readonly string TableName;

        string projectsPath;
        string appDataPath;
        string appTempDataPath;
        string pKfield;
        static string importedDataPath = Directory.GetCurrentDirectory() + @"\data";
        static string tempDataPath = Directory.GetCurrentDirectory() + @"\temp data";
        static string resultsDataPath = Directory.GetCurrentDirectory() + @"\results";
        static string finalResultsFileName = System.IO.Path.Combine(resultsDataPath, "final results.txt");
        static string transformedDataSourceAFileName = System.IO.Path.Combine(resultsDataPath, "transformed data source A.txt");

        //string connectionString = @"Data Source=DULE-I7\SQL2008;Initial Catalog=snapon;Integrated Security=True";
        //string connectionString = @"USER ID=SYSTEM;DATA SOURCE=localhost;PERSIST SECURITY INFO=True;PASSWORD=brbabrba";
        //string connectionString = @"USER ID=SYSTEM;DATA SOURCE=192.168.56.1;PERSIST SECURITY INFO=True;PASSWORD=brbabrba";
        static public string ConnectionString;

        string dataSourceNameSingleRow = "single row table";
        int dataSourceSearchIndex;
        string dataSourceNameLog;

        OnDriveTable singleRowTable = null;
        //OnDriveTable importedTableB = null;
        OnDriveTable importedLogTable = null;

        DataSourceInfo dataSourceInfoSearchRecord;
        DataSourceInfo dataSourceInfoLog;

        ProjectInfo projectInfo;
        MatchEngine matchEngine;

        List<int> cachedDatasetIndexes = new List<int>();

        bool searchInProgress = false;

        DateTime loadTime = DateTime.MinValue;

        //OnDriveTable resultsTable;
        InMemoryTable resultsTable;
        //const int firstCol = 11; // eliminating the first columns which are not important in this application
        const int firstCol = 0;

        //const string noAction = "X";
        const string singleRowOriginal = "O";

        public string[] MatchingFieldNames;

        public string[] TableFieldNames;

        private bool[] tableFieldQuotes;

        HashSet<string> quotesHashSet = new HashSet<string>();

        bool useLog;

        bool doTransformation;

        #endregion

        #region Constructors

        public EngineWrapper(string tableName, bool useLog = false, bool doTransformation = false)
        {
            //createDirectoryIfNotExist(importedDataPath);
            string uncompletedPath = Path.Combine(importedDataPath, "uncomplete");
            createDirectoryIfNotExist(uncompletedPath);


            createDirectoryIfNotExist(tempDataPath);
            createDirectoryIfNotExist(resultsDataPath);
            this.useLog = useLog;
            this.doTransformation = doTransformation;
            IniParser parser = new IniParser("webservice.ini");
            //string connectionString = @"USER ID=SYSTEM;DATA SOURCE=192.168.56.1;PERSIST SECURITY INFO=True;PASSWORD=brbabrba";
            ConnectionString = parser.GetSetting("AppSettings", "connectionstring");
            if (string.IsNullOrEmpty(ConnectionString))
            {
                throw new Exception("connection string not defined");
            }
            projectsPath = parser.GetSetting("AppSettings", "projectsPath");
            if (string.IsNullOrEmpty(projectsPath))
            {
                throw new Exception("projects path not defined");
            }
            appDataPath = parser.GetSetting("AppSettings", "dataPath");
            if (string.IsNullOrEmpty(appDataPath))
            {
                throw new Exception("app data path not defined");
            }
            appTempDataPath = parser.GetSetting("AppSettings", "tempDataPath");
            if (string.IsNullOrEmpty(appTempDataPath))
            {
                throw new Exception("app temp data path  not defined");
            }
            pKfield = parser.GetSetting("PkFieldName", tableName);
            if (useLog)
            {
                if (string.IsNullOrEmpty(pKfield))
                {
                    throw new Exception("pKfield not defined");
                }
            }
            string pathForRegistrationFile = parser.GetSetting("AppSettings", "pathForRegistrationFile");
            this.TableName = tableName;
            dataSourceNameSingleRow += tableName;
            dataSourceNameLog = tableName + "Log";
            RegistrationWrapper registrationWrapper = new RegistrationWrapper();
            registrationWrapper.CustomPathForRegistrationFile = pathForRegistrationFile;
            DateTime expirationTime = RegistrationWrapper.ExpirationDate;
            string error;
            loadData(out error);
        }

        #endregion

        #region Properties and Fields

        public bool SearchInProgress { get; set; }

        #endregion

        #region Methods

        /// <summary>
        /// for now it assumes all fields are text type
        /// </summary>
        /// <param name="hash"></param>
        /// <param name="tableName"></param>
        /// <param name="values"></param>
        /// <param name="fieldNames"></param>
        /// <param name="error"></param>
        /// <returns></returns>
        public bool InsertRecord(string tableName, string[] values, out string error)
        {
            bool result = false;
            error = "";
            try
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("insert into ");
                sb.AppendLine(tableName);
                sb.AppendLine("(");
                for (int i = 0; i < TableFieldNames.Length - 1; i++) // last field is ID, doesn't used in insert operation
                {
                    sb.Append(TableFieldNames[i]);
                    if (i < TableFieldNames.Length - 2)
                    {
                        sb.AppendLine(",");
                    }
                    else
                    {
                        sb.AppendLine("");
                    }
                }
                sb.AppendLine(")");
                sb.AppendLine("values");
                sb.AppendLine("(");
                for (int i = 0; i < TableFieldNames.Length - 1; i++)
                {
                    if (tableFieldQuotes[i])
                    {
                        sb.Append("'");
                    }
                    sb.Append(values[i]);
                    if (tableFieldQuotes[i])
                    {
                        sb.Append("'");
                    }
                    if (i < TableFieldNames.Length - 2)
                    {
                        sb.AppendLine(",");
                    }
                    else
                    {
                        sb.AppendLine("");
                    }
                }
                sb.AppendLine(")");
                executeCmd(sb.ToString());
            }
            catch (Exception ex)
            {
                error = ex.Message;
            }
            return result;
        }

        public bool UpdateRecord(string tableName, string[] values, string id, out string error)
        {
            bool result = false;
            error = "";
            try
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("update ");
                sb.AppendLine(tableName);
                sb.Append(" set ");
                for (int i = 0; i < TableFieldNames.Length - 1; i++) // last field is ID, doesn't used in insert operation
                {
                    sb.Append(TableFieldNames[i]);
                    sb.Append(" = ");
                    if (tableFieldQuotes[i])
                    {
                        sb.Append("'");
                    }
                    sb.Append(values[i]);
                    if (tableFieldQuotes[i])
                    {
                        sb.Append("'");
                    }
                    if (i < TableFieldNames.Length - 2)
                    {
                        sb.AppendLine(",");
                    }
                    else
                    {
                        sb.AppendLine("");
                    }
                }
                sb.Append("where " + pKfield + " = ");
                if (quotesHashSet.Contains(id.ToLower()))
                {
                    sb.Append("'");
                }
                sb.Append(id);
                if (quotesHashSet.Contains(id.ToLower()))
                {
                    sb.Append("'");
                }
                executeCmd(sb.ToString());
            }
            catch (Exception ex)
            {
                error = ex.Message;
            }
            return result;
        }

        public bool DeleteRecord(string tableName, string id, out string error)
        {
            bool result = false;
            error = "";
            try
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("delete from ");
                sb.AppendLine(tableName);
                sb.AppendLine("where " + pKfield + " = ");
                if (quotesHashSet.Contains(id.ToLower()))
                {
                    sb.Append("'");
                }
                sb.Append(id);
                if (quotesHashSet.Contains(id.ToLower()))
                {
                    sb.Append("'");
                }
                executeCmd(sb.ToString());
            }
            catch (Exception ex)
            {
                error = ex.Message;
            }
            return result;
        }

        private void executeCmd(string cmd)
        {
            SqlDbHelper dbHelper = new SqlDbHelper(ConnectionString);
            String error;
            dbHelper.Connect(out error);
            dbHelper.ExecuteCmd(cmd);
            dbHelper.Disconnect();
        }

        static public OnDriveTable GetImportedTableFromSQL(string connectionString, string cmd, string dataSourceName)
        {
            String error;
            SqlDbHelper reader = new SqlDbHelper(connectionString);
            ReaderConfiguration readerConfiguration = reader.GetConfiguration();
            readerConfiguration.SelectCmd = cmd;
            reader.SetConfiguration(readerConfiguration);
            reader.ReadTable(readerConfiguration, true, out error);
            OnDriveTable result = ReaderToVariableTableConvertor.Copy(reader, importedDataPath, dataSourceName, out error);
            return result;
        }

        //static OnDriveTable getImportedTableFromOracle(string connectionString, string cmd, string dataSourceName)
        //{
        //  SqlDbHelper sqlDbHelper = new SqlDbHelper();
        //  OracleDbHelper oracleDbHelper = new OracleDbHelper(connectionString);
        //  ReaderConfiguration readerConfiguration = oracleDbHelper.GetConfiguration();
        //  readerConfiguration.SelectCmd = cmd;
        //  oracleDbHelper.SetConfiguration(readerConfiguration);
        //  oracleDbHelper.ReadTable(readerConfiguration, true);
        //  OnDriveTable result = ReaderToVariableTableConvertor.Copy(oracleDbHelper, importedDataPath, dataSourceName);
        //  return result;
        //}

        public static void RemoveRemainedFiles()
        {
            dataladder.IO.IOHelper.RemoveAllFiles(importedDataPath);
            dataladder.IO.IOHelper.RemoveAllFiles(tempDataPath);
            dataladder.IO.IOHelper.RemoveAllFiles(resultsDataPath);
        }

        public InMemoryTable FindMatches(string tableName, string[] values, int records)
        {
            lock (this)
            {
                while (searchInProgress)
                {
                    Thread.Sleep(10);
                }
                searchInProgress = true;
                try
                {
                    ITable2CoordsMapper tmpResults = findMatchesTemp(values, records);
                    HashSet<int> mixedInputRecords;
                    HashSet<int> groupsWithMixedInputRecords = determineGroupsWithMixedInputRecords(values, records, tmpResults, out mixedInputRecords);
                    string[] columnNames = tmpResults.GetColumnNames();
                    InMemoryTable allGroupsResultTable = new InMemoryTable("AllGroupsResult", /*columnNames,*/ toCheckMemory: false);
                    allGroupsResultTable.AddFields(columnNames);
                    copyTmpToUnifiedResults(tmpResults, groupsWithMixedInputRecords, allGroupsResultTable);
                    groupsWithMixedInputRecords.Clear();
                    foreach (int inputRecordIndex in mixedInputRecords)
                    {
                        string[] oneRecordValues = new string[this.MatchingFieldNames.Length];
                        int valuesIndex = inputRecordIndex * this.MatchingFieldNames.Length;
                        for (int i = 0; i < this.MatchingFieldNames.Length; i++)
                        {
                            oneRecordValues[i] = values[valuesIndex++];
                            tmpResults = findMatchesTemp(oneRecordValues, records);
                            copyTmpToUnifiedResults(tmpResults, groupsWithMixedInputRecords, allGroupsResultTable, inputRecordIndex);
                        }
                    }
                    unifyResults(allGroupsResultTable);
                }
                finally
                {
                    searchInProgress = false;
                } 
            }
            
            //resultsTable.Sort<SortableResultRow>();
            RowsComparator rowsComparator = new FinalResultRowsComparator(resultsTable);
            resultsTable.Sort(rowsComparator);

            return resultsTable;
        }

        private static void copyTmpToUnifiedResults(ITable2CoordsMapper tmpResults,
                                                    HashSet<int> groupsWithMixedInputRecords,
                                                    InMemoryTable allGroupsResultTable,
                                                    int inputRecordIndex = -1)
        {
            int newRowIndex = allGroupsResultTable.RecordCount;
            int previousGroupId;
            if (allGroupsResultTable.RecordCount > 0)
            {
                previousGroupId = (int)allGroupsResultTable.GetData(allGroupsResultTable.RecordCount - 1, (int)PreviewFinalResultsStaticFields.GroupId);
            }
            else
            {
                previousGroupId = 0;
            }
            int newGroupId = -1;
            for (int rowIndex = 0; rowIndex < tmpResults.RecordCount; rowIndex++)
            {
                int groupId = (int)tmpResults.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.GroupId);
                if (rowIndex == 0)
                {
                    newGroupId = previousGroupId + 1;
                }
                if (groupsWithMixedInputRecords.Contains(groupId))
                {
                    continue;
                }
                if (groupId != previousGroupId)
                {
                    newGroupId = previousGroupId + 1;
                    previousGroupId = groupId;
                }
                for (int colIndex = 0; colIndex < tmpResults.ColumnCount; colIndex++)
                {
                    object obj;
                    if ((colIndex == (int)PreviewFinalResultsStaticFields.MatchingRecord) && (inputRecordIndex != -1))
                    {
                        obj = inputRecordIndex;
                    }
                    else if (colIndex == (int)PreviewFinalResultsStaticFields.GroupId)
                    {
                        obj = newGroupId;
                    }
                    else
                    {
                        obj = tmpResults.GetData(rowIndex, colIndex);
                    }
                    allGroupsResultTable.SetData(obj, newRowIndex, colIndex);
                }
                newRowIndex++;
            }
        }

        private HashSet<int> determineGroupsWithMixedInputRecords(string[] values, int records, ITable2CoordsMapper tmpResults, out HashSet<int> mixedInputRecords)
        {
            HashSet<int> result = new HashSet<int>();
            mixedInputRecords = new HashSet<int>();
            Dictionary<int, List<int>> groupsInputRecordsDict = new Dictionary<int, List<int>>();
            // we search for the groups which contain more than one input record
            for (int rowIndex = 0; rowIndex < tmpResults.RecordCount; rowIndex++)
            {
                int datasourceId = (int)tmpResults.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.DataSource);
                int groupId = (int)tmpResults.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.GroupId);
                int matchingRecord;
                if (datasourceId == dataSourceSearchIndex)
                {
                    matchingRecord = (int)tmpResults.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.Record);
                }
                else
                {
                    matchingRecord = (int)tmpResults.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.MatchingRecord);
                }
                List<int> matchingRecordList;
                if (!groupsInputRecordsDict.TryGetValue(groupId, out matchingRecordList))
                {
                    matchingRecordList = new List<int>();
                    groupsInputRecordsDict.Add(groupId, matchingRecordList);
                }
                if (!matchingRecordList.Contains(matchingRecord))
                {
                    matchingRecordList.Add(matchingRecord);
                }
            }
            foreach (KeyValuePair<int, List<int>> keyValuePair in groupsInputRecordsDict)
            {
                List<int> matchingRecordList = keyValuePair.Value;
                if (matchingRecordList.Count > 1)
                {
                    int groupId = keyValuePair.Key;
                    result.Add(groupId);
                    for (int i = 0; i < matchingRecordList.Count; i++)
                    {
                        int matchingRecord = matchingRecordList[i];
                        mixedInputRecords.Add(matchingRecord);
                    }
                }
            }
            return result;
        }

        private ITable2CoordsMapper findMatchesTemp(string[] values, int records)
        {
            dataSourceInfoSearchRecord.InputTable.MakeWritable();
            dataSourceInfoSearchRecord.InputTable.Clear(keepFields: true);
            for (int i = 0; i < values.Length; i++)
            {
                int rowIndex = i / MatchingFieldNames.Length;
                dataSourceInfoSearchRecord.InputTable.SetData(values[i], rowIndex, MatchingFieldNames[i % MatchingFieldNames.Length]);
            }
            if (doTransformation)
            {
                dataSourceInfoSearchRecord.DiagramGenerator.DiagramVariableTableHelper.Processed = false; ;
                dataSourceInfoSearchRecord.RunTransformation();
            }
            if (useLog)
            {
                importedLogTable = importLogTable();
                dataSourceInfoLog.InputTable.ReplaceWith(importedLogTable);
                dataSourceInfoLog.InputTable.MakeReadOnlyShareable();
            }

            matchEngine.ReindexSingleDataSource(dataSourceSearchIndex);
            matchEngine.LoadAllInMemory = true;
            matchEngine.DoMatch(records, clearAllAfterMatching: false);
            matchEngine.ProcessFinalResults(clearAllAfterMatching: false);
            return matchEngine.FinalScoresGroupsTable;
        }

        private MatchEngine initializeMatchingEngine()
        {
            dataladder.Matching.ApplicationSettings.DataPath = appDataPath + @"\";
            dataladder.Matching.ApplicationSettings.TempDataPath = appTempDataPath + @"\";
            String commonDataPath = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "DataMatch Enterprise") + @"\";
            dataladder.App.Paths.SetCommonDataPath(commonDataPath);

            projectInfo = new ProjectInfo();
            projectInfo.Load(projectsPath + @"\" + TableName + ".dmeproj");
            if (projectInfo.DataSourceCount > 1)
            {
                throw new Exception("this example supports only one data source in the project.");
            }
            DataSourceInfo originalDataSourceInfo = projectInfo[0];

            String error;
            originalDataSourceInfo.Refresh(projectInfo.DataPath, Path.Combine(projectInfo.DataPath, "uncomplete"), out error);
            originalDataSourceInfo.CreateDiagram();
            originalDataSourceInfo.RunTransformation();

            dataSourceInfoSearchRecord = new DataSourceInfo(null, new AddressVerificationSettings());
            dataSourceInfoLog = new DataSourceInfo(null,new AddressVerificationSettings());

            if (singleRowTable != null)
            {
                singleRowTable.Dispose();
            }
            singleRowTable = createSingleRowTableAndDetermineFieldNames(projectInfo);
            for (int colIndex = 0; colIndex < MatchingFieldNames.Length; colIndex++)
            {
                string fieldName = MatchingFieldNames[colIndex];
                singleRowTable.SetData("zzzzzzzzz", 0, fieldName);
            }
            if (useLog)
            {
                singleRowTable.SetData(singleRowOriginal, 0, "ACTION");
            }

            dataSourceInfoSearchRecord.InputTable = singleRowTable;
            projectInfo.Add(dataSourceInfoSearchRecord);

            if (useLog)
            {
                dataSourceInfoLog.InputTable = importedLogTable;
                projectInfo.Add(dataSourceInfoLog);
            }

            if (doTransformation)
            {
                // copying the data transformation rules to the log records
                dataSourceInfoSearchRecord.ColumnTransformationList.Copy(originalDataSourceInfo.ColumnTransformationList);
                dataSourceInfoSearchRecord.CreateDiagram();
                dataSourceInfoSearchRecord.RunTransformation();
                if (useLog)
                {
                    dataSourceInfoLog.ColumnTransformationList.Copy(originalDataSourceInfo.ColumnTransformationList);
                }
            }


            MatchDefinitionBuilder matchDefinitionBuilder = projectInfo.MatchDefinitionBuilder;

            // engine is prepared to support multiple match definitions, here we work only with one
            MultipleMatchDefinitionsManager multipleMatchDefinitionsManager = matchDefinitionBuilder.MultipleMatchDefinitionsManager;

            string firstTableInTheproject = projectInfo[0].InputTable.Name;

            for (int i = 0; i < multipleMatchDefinitionsManager.Count; i++)
            {
                MatchDefinitionsList matchDefinitionsList = multipleMatchDefinitionsManager[i];
                for (int singleDefinitionIndex = 0; singleDefinitionIndex < matchDefinitionsList.Count; singleDefinitionIndex++)
                {
                    MatchDefinitionSingle matchDefinitionSingle = matchDefinitionsList[singleDefinitionIndex];
                    bool found;
                    string fieldName = matchDefinitionSingle.GetMappedFieldName(firstTableInTheproject, out found);
                    if (found) // in case of multiple definitions it could be found == false
                    {
                        matchDefinitionSingle.MapField(dataSourceNameSingleRow, fieldName);
                        if (useLog)
                        {
                            matchDefinitionSingle.MapField(dataSourceNameLog, fieldName);
                        }
                    }
                }
            }

            //groupFields();

            // initializing match engine
            //MatchEngine matchEngine = new MatchEngine(multipleMatchDefinitionsManager, tempDataPath, resultsDataPath);
            //MatchEngine matchEngine = projectInfo.MatchEngine;
            //MatchEngine matchEngine = projectInfo.CreateMatchEngine();
            //matchEngine.Add(dataSourceNameSingleRow, dataSourceInfoSearchRecord.TransformedValuesTable);
            //matchEngine.Add(dataSourceNameSingleRow, singleRowTable);
            //if (useLog)
            //{
            //  matchEngine.Add(dataSourceNameLog, importedLogTable);
            //}

            matchDefinitionBuilder.InitialMapping();

            MatchEngine matchEngine = projectInfo.CreateMatchEngine();
            matchEngine.AllRecordsInGoupMustBeSimilar = false;

            matchEngine.ClearPairToMatchList(); // they are loaded with the project...
            matchEngine.DoIndex();
            dataSourceSearchIndex = projectInfo.DataSourceCount - 1;
            for (int i = 0; i < projectInfo.DataSourceCount - 1; i++)
            {
                matchEngine.AddPairToMatchList(i, dataSourceSearchIndex); // to find matches between data sources A and B
            }
            if (useLog)
            {
                matchEngine.AddPairToMatchList(1, 2); // to find matches between data sources B and C
            }
            cachedDatasetIndexes.Clear();
            cachedDatasetIndexes.Add(0);

            matchEngine.SetCachedDataSources(cachedDatasetIndexes);

            matchEngine.LoadAllInMemory = true;
            matchEngine.DoMatch(clearAllAfterMatching: false);
            matchEngine.ProcessFinalResults(clearAllAfterMatching: false);
            List<string> tmp = new List<string>();
            TableFieldNames = new string[matchDefinitionBuilder.AvailableFields.MappedFieldsRowList.Count];
            for (int i = 0; i < matchDefinitionBuilder.AvailableFields.MappedFieldsRowList.Count; i++)
            {
                MappedFieldsRow mappedFieldsRow = matchDefinitionBuilder.AvailableFields.MappedFieldsRowList[i];
                FieldMapInfo fieldMapInfo = mappedFieldsRow[this.TableName];
                if (fieldMapInfo != null)
                {
                    string fieldName = fieldMapInfo.FieldName.Trim();
                    if (!string.IsNullOrEmpty(fieldName))
                    {
                        tmp.Add(fieldName);
                    }
                }
            }
            TableFieldNames = tmp.ToArray();
            //getSqlFieldTypes();
            return matchEngine;
        }

        private void getSqlFieldTypes()
        {
            tableFieldQuotes = new bool[TableFieldNames.Length];
            quotesHashSet = new HashSet<string>();
            string cmd = "select t.name as typename, c.name as columnname from syscolumns c\r\n" +
                         "left join sysobjects o on (c.id = o.id) left join systypes t on (c.xtype = t.xtype)\r\n" +
                         "where t.status = 0 and o.name = '" + this.TableName + "'";
            OnDriveTable typesTable = GetImportedTableFromSQL(ConnectionString, cmd, "types");
            for (int rowIndex = 0; rowIndex < typesTable.RecordCount; rowIndex++)
            {
                string typeName = typesTable.GetData(rowIndex, 0).ToString().ToLower();
                if (typeName.Contains("char") || typeName.Contains("date"))
                {
                    string columnName = typesTable.GetData(rowIndex, 1).ToString().ToLower();
                    quotesHashSet.Add(columnName);
                }
            }
            for (int i = 0; i < TableFieldNames.Length; i++)
            {
                string fieldName = TableFieldNames[i].ToLower();
                tableFieldQuotes[i] = quotesHashSet.Contains(fieldName);
            }
        }

        private OnDriveTable createSingleRowTableAndDetermineFieldNames(ProjectInfo projectInfo)
        {
            OnDriveTable result = new OnDriveTable(importedDataPath, dataSourceNameSingleRow, toDeleteExisting: true);
            List<string> allFieldNames = determineFieldNames(projectInfo);
            int fieldsCount = allFieldNames.Count;
            MatchingFieldNames = new string[fieldsCount];
            for (int i = 0; i < allFieldNames.Count; i++)
            {
                string fieldName = allFieldNames[i];
                MatchingFieldNames[i] = fieldName;
                result.AddField(fieldName, typeof(string));
            }
            if (useLog)
            {
                result.AddField("ACTION", typeof(string));
            }
            return result;
        }

        private List<string> determineFieldNames(ProjectInfo projectInfo)
        {
            DataSourceInfo originalDataSourceInfo = projectInfo[0];
            string tableName = originalDataSourceInfo.Name;
            TransformationDiagram transformationDiagram = originalDataSourceInfo.DiagramGenerator.DiagramVariableTableHelper.FirstTransformationDiagram;
            List<string> tmp = new List<string>();
            MultipleMatchDefinitionsManager multipleMatchDefinitionsManager = projectInfo.MatchDefinitionBuilder.MultipleMatchDefinitionsManager;
            for (int matchDefinitionIndex = 0; matchDefinitionIndex < multipleMatchDefinitionsManager.Count; matchDefinitionIndex++)
            {
                List<MatchDefinitionMappedToField> matchDefinitionMappedToFieldList = multipleMatchDefinitionsManager[matchDefinitionIndex].DetermineFieldsToIndex(originalDataSourceInfo.Name, originalDataSourceInfo.TransformedValuesTable);
                for (int i = 0; i < matchDefinitionMappedToFieldList.Count; i++)
                {
                    MatchDefinitionMappedToField matchDefinitionMappedToField = matchDefinitionMappedToFieldList[i];
                    string fieldName = matchDefinitionMappedToField.FieldName;
                    DataFlow output = transformationDiagram.Outputs[fieldName];
                    if (output != null)
                    {
                        if (doTransformation)
                        {

                            for (int ii = 0; ii < transformationDiagram.Inputs.Count; ii++)
                            {
                                DataFlow input = transformationDiagram.Inputs[ii];
                                if ((output.IsAfter(input)) | (input == output))
                                {
                                    if (!tmp.Contains(input.Name))
                                    {
                                        tmp.Add(input.Name);
                                    }
                                }
                            }
                        }
                        else
                        {
                            if (!tmp.Contains(output.Name))
                            {
                                tmp.Add(output.Name);
                            }
                        }
                    }
                }
            }
            return tmp;
        }

        private void unifyResults(InMemoryTable combinedResults)
        {
            if (resultsTable != null)
            {
                resultsTable.Dispose();
            }
            //resultsTable = new OnDriveTable(importedDataPath, this.matchEngine.Name + " results", toDeleteExisting: true);
            resultsTable = new InMemoryTable("Results Table", /*new string[] { }, */toCheckMemory: false);
            int count = useLog ? combinedResults.ColumnCount - 2 : combinedResults.ColumnCount;
            for (int colIndex = firstCol; colIndex < count; colIndex++) // without action and last update fields
            {
                string fieldName = combinedResults.GetColumnName(colIndex);
                resultsTable.AddField(fieldName, OnDriveTable.StorageDataType.Other);
            }
            string id;
            string action;
            Dictionary<string, string> logRecords = new Dictionary<string, string>();
            if (useLog)
            {
                for (int rowIndex = 0; rowIndex < dataSourceInfoLog.InputTable.RecordCount; rowIndex++) // record 0 is the lookup record itself...
                {
                    id = dataSourceInfoLog.InputTable.GetData(rowIndex, pKfield).ToString();
                    action = (string)dataSourceInfoLog.InputTable.GetData(rowIndex, "ACTION");
                    logRecords.Add(id, action);
                }
            }
            for (int rowIndex = 0; rowIndex < combinedResults.RecordCount; rowIndex++)
            {
                int dataSourceIndex = (int)combinedResults.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.DataSource);
                //if (action == singleRowOriginal) // this is the lookup record itself...
                if (dataSourceIndex == dataSourceSearchIndex)
                {
                    continue;
                }
                if (useLog)
                {
                    id = combinedResults.GetData(rowIndex, pKfield).ToString().Trim();
                    action = combinedResults.GetData(rowIndex, "ACTION").ToString();
                    if (!string.IsNullOrEmpty(action)) // for log records
                    {
                        if (action == "D") // record is from log, record deleted, ignore it...
                        {
                            continue;
                        }
                        else
                        {
                            copyResultRecord(combinedResults, rowIndex);
                        }
                    }
                    else // not a log record
                    {
                        id = combinedResults.GetData(rowIndex, pKfield).ToString();
                        if (logRecords.TryGetValue(id, out action)) // original record, changed ignore it...
                        {
                            continue;
                        }
                        else
                        {
                            copyResultRecord(combinedResults, rowIndex);
                        }
                    }
                }
                else
                {
                    copyResultRecord(combinedResults, rowIndex);
                }
            }
        }

        private void copyResultRecord(InMemoryTable combinedResults, int rowIndex)
        {
            int newRowIndex = resultsTable.RecordCount;
            int count = useLog ? combinedResults.ColumnCount - 2 : combinedResults.ColumnCount;
            for (int colIndex = firstCol; colIndex < count; colIndex++) // without action and last update fields
            {
                object obj = combinedResults.GetData(rowIndex, colIndex);
                resultsTable.SetData(obj, newRowIndex, colIndex - firstCol);
            }
        }

        private void loadData(out string error)
        {
            error = "";
            System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
            stopwatch.Start();

            projectInfo = new ProjectInfo();
            if (matchEngine != null)
            {
                matchEngine.Dispose();
                matchEngine = null;
            }
            loadTime = DateTime.Now;

            if (useLog)
            {
                importedLogTable = importLogTable();
            }

            matchEngine = initializeMatchingEngine();
            stopwatch.Stop();
        }

        //private void groupFields()
        //{
        //  MatchDefinitionsList matchDefinitionsList = this.projectInfo.MatchDefinitionBuilder.MultipleMatchDefinitionsManager[0];
        //  for (int i = 0; i < matchDefinitionsList.Count; i++)
        //  {
        //    MatchDefinitionSingle matchDefinitionSingle = matchDefinitionsList[i];
        //    if (false) // for now...
        //    {
        //      matchDefinitionSingle.GroupId = 0;
        //      matchDefinitionSingle.GroupLevel = 0.60f;
        //      matchDefinitionSingle.MaxEmptyWeightBelow = 200;
        //      matchDefinitionSingle.MaxMismatchWeightBelow = 200;
        //      matchDefinitionSingle.MaxTotalWeightBelow = 200;
        //    }
        //    else
        //    {
        //      matchDefinitionSingle.GroupId = -1;
        //    }
        //  }
        //}

        private OnDriveTable importLogTable()
        {
            string cmd = "select l.* from " + TableName + "log l " +
                         "right join (select " + pKfield + ", max(lastupdate) as lastupdate from " + TableName + "log group by " + pKfield + ") l2 on l." + pKfield + " = l2." + pKfield + " and l.lastupdate = l2.lastupdate " +
                         "where l.lastupdate > " +
                         "'" + SqlDbHelper.DateTimeToString(loadTime) + "'";
            // OracleDbHelper.DateTimeToString(loadTime);
            OnDriveTable result = GetImportedTableFromSQL(ConnectionString, cmd, dataSourceNameLog);
            return result;
        }

        private static bool createDirectoryIfNotExist(string dir)
        {
            bool result = Directory.Exists(dir);
            if (!result)
            {
                try
                {
                    Directory.CreateDirectory(dir);
                    result = true;
                }
                catch
                {
                    result = false;
                }
            }
            return result;
        }

        #endregion

        #region IDisposable members

        public void Dispose()
        {
            if (singleRowTable != null)
            {
                singleRowTable.Dispose();
                singleRowTable = null;
            }
            if (importedLogTable != null)
            {
                importedLogTable.Dispose();
                importedLogTable = null;
            }
            //if (importedTableB != null)
            //{
            //  importedTableB.Dispose();
            //  importedTableB = null;
            //}
            //this.matchEngine.Dispose();
            this.projectInfo.Dispose();
        }

        #endregion
    }
}
