﻿using System;
using System.Collections.Generic;
using System.Text;
using dataladder.Data;
using dataladder.XtraGridHelper;
using dataladder.Matching;
using DataMatch.Data.Enums;

namespace SampleServiceNamespace
{
  public class SortableResultRow : SortableRow
  {
    #region Fields

    double score;
    int matchingRecord;

    #endregion

    #region Methods

    public override SortableRow GetObjectFromRow(IContainer2CoordsMapper table, int rowIndex, int chunkNumber)
    {
      SortableResultRow result = new SortableResultRow();
      result.rowIndex = rowIndex;
      result.chunkNumber = chunkNumber;
      CopyDataFromRow(table, result, rowIndex);
      return result;
    }

    public override void CopyDataFromRow(IContainer2CoordsMapper sourceMapper, SortableRow destSortableRow, int rowIndex)
    {
      SortableResultRow destRow = destSortableRow as SortableResultRow;
      destRow.matchingRecord = (int)sourceMapper.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.MatchingRecord); // hard coded
      destRow.score = (double)sourceMapper.GetData(rowIndex, (int)PreviewFinalResultsStaticFields.Score); // hard coded
    }

    public override int CompareTo(object obj)
    {
      int result = 0;
      SortableResultRow other = obj as SortableResultRow;
      if (this.matchingRecord < other.matchingRecord)
      {
        result = -1;
      }
      else if (this.matchingRecord > other.matchingRecord)
      {
        result = 1;
      }
      else if (this.score < other.score)
      {
        result = 1;
      }
      else if (this.score > other.score)
      {
        result = -1;
      }
      return result;
    }

    #endregion
  }
}