﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.ServiceModel.Description;
using SampleServiceNamespace;

namespace SelfHostConsole
{
  class Program
  {
    static void Main(string[] args)
    {
      using (ServiceHost host = new ServiceHost(typeof(SampleService)))
      {

        ServiceDebugBehavior debug = host.Description.Behaviors.Find<ServiceDebugBehavior>();

        // if not found - add behavior with setting turned on 
        if (debug == null)
        {
          host.Description.Behaviors.Add(new ServiceDebugBehavior() { IncludeExceptionDetailInFaults = true });
        }
        else
        {
          // make sure setting is turned ON
          if (!debug.IncludeExceptionDetailInFaults)
          {
            debug.IncludeExceptionDetailInFaults = true;
          }
        }
        host.Open();

        Console.WriteLine("Service up and running at:");
        foreach (var ea in host.Description.Endpoints)
        {
          Console.WriteLine(ea.Address);
        }

        Console.ReadLine();
        host.Close();
      }
    }
  }
}
