﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

namespace WebApplicationUsingWebService
{
  public partial class _Default : System.Web.UI.Page
  {
    #region Constants

    bool useLog = false;

    const string searchConstID = "_dynSearchControls_ID";
    const string editConstID = "_dynEditControls_ID";

    const string taskTable = "TaskTable";

    const string box = "box";
    const string label = "label";

    #endregion

    #region Methods

    private string[] getMatchingValues()
    {
      return getBoxValues(this.DynamicSearchPanel);
    }

    private string[] getInsertValues()
    {
      return getBoxValues(this.DynamicEditPanel);
    }

    //private string[] getGridValues(int rowIndex)
    //{
    //  string[] matchingValues = getMatchingValues();
    //  int startIndex = matchingValues.Length + 1; // score fields, + 1 is for total score
    //  List<string> tmp = new List<string>();
    //  for (int colIndex = startIndex; colIndex < ResultsGridView.Columns.Count; colIndex++)
    //	{
    //    string value= ResultsGridView.Rows[rowIndex].Cells[colIndex].ToString();
    //    tmp.Add(value);
    //	}
    //  string[] result = tmp.ToArray();
    //  return result;
    //}

    private string[] getBoxValues(Panel panel)
    {
      List<string> tmp = new List<string>();
      for (int i = 0; i < panel.Controls.Count; i++)
      {
        Control control = panel.Controls[i];
        if (control is TextBox)
        {
          tmp.Add((control as TextBox).Text);
        }
      }
      return tmp.ToArray();
    }

    private void saveControlValues()
    {
      saveControlValues(DynamicSearchPanel, searchConstID);
      if (useLog)
      {
        saveControlValues(DynamicEditPanel, editConstID);
      }
    }

    private void saveControlValues(Panel panel, string constID)
    {
      List<string> dynamicValues = new List<string>();
      for (int i = 0; i < panel.Controls.Count; i++)
      {
        Control control = panel.Controls[i];
        if (control is TextBox)
        {
          TextBox textBox = control as TextBox;
          dynamicValues.Add(box);
          dynamicValues.Add(textBox.ID);
          dynamicValues.Add(textBox.Text);
        }
        if (control is Label)
        {
          Label lbl = control as Label;
          dynamicValues.Add(label);
          dynamicValues.Add(lbl.ID);
          dynamicValues.Add(lbl.Text);
        }
      }
      this.ViewState[constID] = dynamicValues;
      this.SaveViewState();
    }

    private void restoreControls(string constID, Panel panel)
    {
      panel.Controls.Clear();
      List<string> dynamicValues = this.ViewState[constID] as List<string>;
      if (dynamicValues != null)
      {
        int index = 0;
        for (int i = 0; i < dynamicValues.Count / 3; i++)
        {
          string type = dynamicValues[index++];
          string id = dynamicValues[index++];
          string text = dynamicValues[index++];
          if (panel.FindControl(id) == null)
          {
            if (type == box)
            {
              TextBox textBox = new TextBox();
              textBox.ID = id;
              textBox.Text = text;
              panel.Controls.Add(textBox);
            }
            else if (type == label)
            {
              Label lbl = new Label();
              lbl.ID = id;
              lbl.Text = text;
              panel.Controls.Add(lbl);
            }
          }
        }
      }
    }

    private void bindSearchResults()
    {
      if (Session[taskTable] != null)
      {
        ResultsGridView.Columns.Clear();
        ResultsGridView.DataSource = null;
        ResultsGridView.DataSource = Session[taskTable];
        ResultsGridView.DataBind();
      }
    }

    private void resetLabels()
    {
      ErrorLabel.Text = "...";
      TimeLabel.Text = "...";
    }

    private int getFirstDataCol()
    {
      int result = 0;
      DataTable dataTable = Session[taskTable] as DataTable;
      if (dataTable != null)
      {
        for (int i = 0; i < dataTable.Columns.Count; i++)
        {
          string fieldName = dataTable.Columns[i].ColumnName;
          result = i;
          if (fieldName.ToLower().EndsWith("score"))
          {
            continue;
          }
          else
          {
            break;
          }
        }
      }
      return result;
    }

    #endregion

    #region Properties and Fields

    string tableName { get { return projectsRadioButtonList.SelectedValue; } }

    #endregion

    #region Events

    protected void Page_Load(object sender, EventArgs e)
    {
      restoreControls(searchConstID, DynamicSearchPanel);
      if (useLog)
      {
        restoreControls(editConstID, DynamicEditPanel);
      }
      else
      {
        insertButton.Visible = false;
        updateButton.Visible = false;
        deleteButton.Visible = false;
      }
      bindSearchResults();
    }

    protected void SearchButtonClick(object sender, EventArgs e)
    {
      System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
      stopwatch.Start();
      //ErrorLabel.Visible = false;
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        int records;
        int.TryParse(RecordsTextBox.Text, out records);
        if (records <= 0)
        {
          ErrorLabel.Text = "Invalid records count";
          //ErrorLabel.Visible = true;
          return;
        }
        string[] matchingValues = getMatchingValues();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);

        string[] matches = client.GetMatches(hash, tableName, matchingValues, records);
        DataTable dataTable = new DataTable();
        int resultIndex = 0;
        if (matches.Length > 1)
        {
          int colCount;
          if (int.TryParse(matches[resultIndex++], out colCount))
          {
            for (int colIndex = 0; colIndex < colCount; colIndex++)
            {
              dataTable.Columns.Add(new DataColumn(matches[resultIndex++], typeof(string), "", MappingType.Element));
            }
            int returnedRecords = ((matches.Length - 1) / dataTable.Columns.Count) - 1;
            for (int i = 0; i < returnedRecords; i++)
            {
              DataRow dataRow = dataTable.NewRow();
              for (int col = 0; col < colCount; col++)
              {
                dataRow[col] = matches[resultIndex++];
              }
              dataTable.Rows.Add(dataRow);
            }
          }
          if (this.DynamicEditPanel.Controls.Count == 0)
          {
            bool lastScoreColReached = false;
            for (int i = 0; i < dataTable.Columns.Count; i++)
            {
              string fieldName = dataTable.Columns[i].ColumnName;
              if (!lastScoreColReached)
              {
                if (fieldName.ToLower().EndsWith("score"))
                {
                  continue;
                }
                else
                {
                  lastScoreColReached = true;
                }
              }
              Label label = new Label();
              label.ID = fieldName + editConstID + "_label";
              label.Text = fieldName;
              this.DynamicEditPanel.Controls.Add(label);
              TextBox textBox = new TextBox();
              textBox.ID = fieldName + editConstID;
              this.DynamicEditPanel.Controls.Add(textBox);
            }
          }
        }
        Session[taskTable] = dataTable;
        bindSearchResults();
      }
      saveControlValues();
      TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
    }

    protected void InitButton_Click(object sender, EventArgs e)
    {
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);
        if (client.Init(hash, tableName, useLog))
        {
          string[] matchFieldNames = client.GetMatchingFields(hash, tableName);
          this.DynamicSearchPanel.Controls.Clear();
          for (int i = 0; i < matchFieldNames.Length; i++)
          {
            string fieldName = matchFieldNames[i];
            Label label = new Label();
            label.ID = fieldName + searchConstID + "_label";
            label.Text = fieldName;
            this.DynamicSearchPanel.Controls.Add(label);
            TextBox textBox = new TextBox();
            textBox.ID = fieldName + searchConstID;
            this.DynamicSearchPanel.Controls.Add(textBox);
          }
          ErrorLabel.Text = tableName + " started...";
        }
        else
        {
          ErrorLabel.Text = tableName + " didn't start";
        }
        saveControlValues();
        TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
      }
    }

    protected void Button1_Click1(object sender, EventArgs e)
    {
      System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
      stopwatch.Start();

      TextBox textBox = new TextBox();
      textBox.Text = "brba";
      this.DynamicSearchPanel.Controls.Add(textBox);
    }

    protected void testProjectButton_Click(object sender, EventArgs e)
    {
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);
        if (client.IsRunning(hash, tableName))
        {
          ErrorLabel.Text = tableName + " project is loaded and running";
        }
        else
        {
          ErrorLabel.Text = tableName + " project is not active";
        }
        saveControlValues();
        TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
      }
    }

    protected void unloadButton_Click(object sender, EventArgs e)
    {
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);
        if (!client.IsRunning(hash, tableName))
        {
          ErrorLabel.Text = tableName + " project is not active. It cannot be unloaded.";
        }
        else
        {
          if (client.Unload(hash, tableName))
          {
            ErrorLabel.Text = tableName + " project is not active";
          }
        }
        saveControlValues();
        TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
      }
    }

    protected void insertButton_Click(object sender, EventArgs e)
    {
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);
        if (!client.IsRunning(hash, tableName))
        {
          ErrorLabel.Text = tableName + " project is not active. It cannot be edited.";
        }
        else
        {
          string error;
          string[] values = getInsertValues();
          if (client.InsertRecord(out error, hash, tableName, values))
          {
            ErrorLabel.Text = "record inserted into " + tableName;
          }
          else
          {
            ErrorLabel.Text = error;
          }
        }
        saveControlValues();
        TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
      }
    }

    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
      ErrorLabel.Text = ResultsGridView.SelectedIndex.ToString();
      bindSearchResults();
      string[] matchingValues = getMatchingValues();
      DataTable dataTable = Session[taskTable] as DataTable;
      DataRow dataRow = dataTable.Rows[ResultsGridView.SelectedIndex];
      int startIndex = getFirstDataCol();
      int counter = 0;
      for (int i = startIndex; i < dataTable.Columns.Count; i++)
      {
        (DynamicEditPanel.Controls[counter++ * 2 + 1] as TextBox).Text = dataRow[i].ToString();
      }
    }

    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
      return;
      ResultsGridView.EditIndex = e.NewEditIndex;
      bindSearchResults();
      string[] matchingValues = getMatchingValues();
      DataTable dataTable = Session[taskTable] as DataTable;
      DataRow dataRow = dataTable.Rows[e.NewEditIndex];
      int startIndex = matchingValues.Length + 1; // score fields, + 1 is for total score
      int counter = 0;
      for (int i = startIndex; i < dataTable.Columns.Count; i++)
      {
        (DynamicEditPanel.Controls[counter++ * 2 + 1] as TextBox).Text = dataRow[i].ToString();
      }
    }

    protected void updateButton_Click(object sender, EventArgs e)
    {
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);
        if (!client.IsRunning(hash, tableName))
        {
          ErrorLabel.Text = tableName + " project is not active. It cannot be edited.";
        }
        else
        {
          string error;
          string[] values = getInsertValues();
          string id = values[0];
          if (client.UpdateRecord(out error, hash, tableName, values, id))
          {
            ErrorLabel.Text = "record from " + tableName + " updated";
          }
          else
          {
            ErrorLabel.Text = error;
          }
        }
        saveControlValues();
        TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
      }
    }

    protected void deleteButton_Click(object sender, EventArgs e)
    {
      resetLabels();
      using (SelfHostedService.SampleServiceClient client = new SelfHostedService.SampleServiceClient())
      {
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        stopwatch.Start();
        string hash = SampleServiceNamespace.PortableHash.GetHash(tableName);
        if (!client.IsRunning(hash, tableName))
        {
          ErrorLabel.Text = tableName + " project is not active. It cannot be edited.";
        }
        else
        {
          string error;
          string[] values = getInsertValues();
          string id = values[0];
          if (client.DeleteRecord(out error, hash, tableName, id))
          {
            ErrorLabel.Text = "record from " + tableName + " deleted";
          }
          else
          {
            ErrorLabel.Text = error;
          }
        }
        saveControlValues();
        TimeLabel.Text = "response time: " + stopwatch.Elapsed.ToString();
      }
    }

    protected void projectsRadioButtonList_SelectedIndexChanged(object sender, EventArgs e)
    {
      this.DynamicEditPanel.Controls.Clear();
      saveControlValues();
    }

    #endregion
  }
}