﻿using DataMatch.AddressVerification.Contracts;
using DataMatch.AddressVerification.Enums;

namespace DataMatch.AddressVerification
{
    public static class CassManagerFactory
    {
        /// <summary>
        /// Crate new instance of the CassManager. Custom = Default at the moment.
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        public static ICassManager Create(CassManagerTypes type)
        {
            switch (type)
            {
                case CassManagerTypes.Default:
                case CassManagerTypes.Custom:
                    return new CassManager();
                default:
                    return new CassManager();
            }
        }
    }
}
