﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace SampleWebService
{
    [ServiceContract]
    public interface IDmeApiWebService
    {
        /// <summary>
        /// Init all projects defined in Settings
        /// </summary>
        [OperationContract]
        void Init();

        /// <summary>
        /// Reset Service and init again
        /// </summary>
        [OperationContract]
        void ReInit();

        /// <summary>
        /// Get All Errors
        /// </summary>
        [OperationContract]
        string[] GetErors();

        /// <summary>
        /// Get list loaded projects
        /// </summary>
        [OperationContract]
        string[] GetLoadedProjects();

        /// <summary>
        /// Match record with primary key 'id' and matching fields 'values'
        /// Insert the answer of matching to the table defined into Settings 'ResultTable'
        /// Setting 'Cache' defines that checked record will be added to the cache table imediatly or after command from outside
        /// </summary>
        /// <param name="projName"></param>
        /// <param name="id"></param>
        /// <param name="values"></param>
        [OperationContract]
        void MatchAndInsert(string projName, long id, string[] values);

        [OperationContract]
        string MatchAndInsertSync(string projName, long id, string[] values);


        [OperationContract]
        string[] GetPathes();

        /// <summary>
        /// add values to cache table 
        /// </summary>
        /// <param name="projName"></param>
        /// <param name="matchihgValues"></param>
        /// <returns></returns>
        [OperationContract]
        bool AddToCachedTable(string projName, string[] matchihgValues);
        
        /// <summary>
        /// get version of Api and Demo
        /// <returns></returns>
        [OperationContract]
        string GetVersion();
    }
}
