﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LiveSearchDemo.Entities;

namespace LiveSearchDemo.Contracts
{
    internal interface IPresenter
    {
        void LoadProjectsPath();

        void LoadProject();

        void LoadSavedSearchValues();

        void SaveSearchValues();

        /// <summary>
        /// 
        /// </summary>
        /// <returns>how long was matching</returns>
        TimeSpan PerformLiveSearch();

        void CheckForDuplicates();

        void InsertRecord();

        void ChangeMode(bool useThresholds, bool useCasheTable);

        void SetThresholds(double highLevel, double lowLevel);
    }
}
