﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AddressValidation.Backend.Winform
{
    public partial class Form1 : Form
    {
        RecordCleaner cleaner;
        public Form1()
        {
            InitializeComponent();

            if (!RecordCleaner.ValidateProjects(Properties.Settings.Default.TransformationProject,
                                        Properties.Settings.Default.MatchingProject, out String errors))
            {
                MessageBox.Show(errors);
                cleaner = new RecordCleaner(Properties.Settings.Default.ConfigFile,
                                            Properties.Settings.Default.ConnectionString
                                            );
            }
            else
            {
                cleaner = new RecordCleaner(Properties.Settings.Default.TransformationProject,
                                            Properties.Settings.Default.MatchingProject,
                                            Properties.Settings.Default.ConfigFile,
                                            Properties.Settings.Default.ConnectionString
                                            );
            }
            transLabel.Text = $"Transformation project: {Properties.Settings.Default.TransformationProject}";
            matchLabel.Text = $"Matching project: {Properties.Settings.Default.MatchingProject}";
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (cleaner == null)
                return;

            cleaner.InsertRecords(
                new string[]
                {
                    textBox1.Text, textBox2.Text,textBox3.Text,textBox4.Text,textBox5.Text,
                    textBox6.Text,textBox7.Text,textBox8.Text,textBox9.Text,textBox10.Text,
                }, 
                new string[]
                {
                    "FirstName", "LastName", "Address1", "Zip", "City",
                    "Address2",  "Phone",  "Custom2", "Custom1", "Email",
                },
                out DataTable history, 
                out DataTable trans, out DataTable match, out DataTable master, 
                out DataTable dupl,
                out string[] msgs);
            dataGridView1.DataSource = history;
            dataGridView2.DataSource = trans;
            dataGridView3.DataSource = match;
            dataGridView4.DataSource = dupl;
            dataGridView5.DataSource = master;

            listBox1.Items.Clear();
            if (msgs != null)
            {
                foreach (var item in msgs)
                {
                    listBox1.Items.Add(item);
                }
            }
            listBox1.Items.Add("----");
            var cols = cleaner?.GetMatchingFields();
            if (cols != null)
            {
                foreach (var item in cols)
                {
                    listBox1.Items.Add(item);
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            cleaner?.Clear();
            dataGridView1.DataSource = null;
            dataGridView2.DataSource = null;
            dataGridView3.DataSource = null;
            dataGridView4.DataSource = null;
            dataGridView5.DataSource = null;
        }

    }
}
