﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using DataMatch.AddressVerification;
using DataMatch.AddressVerification.Contracts;
using DataMatch.AddressVerification.Entities;
using DataMatch.AddressVerification.Enums;

namespace AddressValidationTests
{
    [TestClass]
    public class AddressVerificationTests
    {
        [TestMethod]
        public void TestAddressSuggestions()
        {
            String primaryAddress = @"Boston";
            ICassManager cassManager = CassManagerFactory.Create(CassManagerTypes.Default);
            ICassRequest cassRequest = new CassRequest(primaryAddress);
            ICassResponses responses = cassManager.GetAddressSuggestions(cassRequest);
            Assert.IsTrue(responses.Responses.Length > 0);
        }

        [TestMethod]
        public void TestAddressSuggestionsJson()
        {
            String primaryAddress = @"Boston";
            ICassManager cassManager = CassManagerFactory.Create(CassManagerTypes.Default);
            String jsonResponse = cassManager.GetAddressSuggestions(primaryAddress);
            Assert.IsFalse(String.IsNullOrEmpty(jsonResponse));
        }
    }
}
