﻿using System;
using System.Runtime.Serialization;
using DataMatch.AddressVerification.Contracts;

namespace DataMatch.AddressVerification.Entities
{
    [DataContract]
    public class CassResponse : ICassResponse
    {
        private static CassResponse _default;

        public CassResponse()
        {
        }

        [DataMember(Name = "value")]
        public String AddressMain { get; set; }

        [DataMember(Name = "address_main")]
        public String AddressPrimary { get; set; }

        [DataMember(Name = "address_secondary")]
        public String AddressSecondary { get; set; }
        
        [DataMember(Name = "country")]
        public String Country { get; set; }

        [DataMember(Name = "state")]
        public String State { get; set; }

        [DataMember(Name = "city")]
        public String City { get; set; }

        public static CassResponse Default => CassResponse._default ?? (CassResponse._default = new CassResponse());
    }
}
