﻿using System;

using dataladder.Data;
using dataladder.Licensing;
using dataladder.Matching.Project;

namespace UsingTheExistingProject
{
    class Program
    {
        #region Fields


        #endregion

        static void Main(string[] args)
        {
            RegistrationWrapper registrationWrapper = new RegistrationWrapper();
            registrationWrapper.CustomPathForRegistrationFile = @"D:\API\registration\";
            DateTime expirationTime = RegistrationWrapper.ExpirationDate;
            Console.WriteLine("Expiration time: " + expirationTime);

            dataladder.Matching.ApplicationSettings.DataPath = @"D:\API\data\";
            dataladder.Matching.ApplicationSettings.TempDataPath = @"D:\API\temp\";

            ProjectInfo projectInfo = new ProjectInfo();
            //projectInfo.Load(@"D:\API\projects\ApiExampleCsv.dmeproj"); 
            projectInfo.Load(@"D:\API\projects\ApiExampleExcel.dmeproj");

            Console.WriteLine("project: \"" + projectInfo.ProjectName + "\" loaded.");
                       
            projectInfo.RunTransformation();
            Console.WriteLine("data transformed");
            projectInfo.MatchEngine.DoIndex();
            Console.WriteLine("indexing finished");
            projectInfo.MatchEngine.DoMatch();
            Console.WriteLine("matching finished");
            projectInfo.MatchEngine.ProcessFinalResults();
            Console.WriteLine("results processed");

            // export in DB
            string connectionString = @"Data Source=localhost\SQLEXPRESS;Initial Catalog=API;Integrated Security=True";
            try
            {
                SqlDbHelper sqlDbHelper = new SqlDbHelper(connectionString);
                string exportTableName = projectInfo.ProjectName + " results";
                string schemaName = "dbo";
                bool truncate = sqlDbHelper.TableExists(schemaName, exportTableName);
                dataladder.Data.IReaderHelper.Export(projectInfo.MatchEngine.FinalScoresGroupsTable,
                    sqlDbHelper,
                    schemaName: "",
                    tableName: exportTableName,
                    onTableProgress: null,
                    bulkCopy: true,
                    truncate: truncate);
                Console.WriteLine("groups exported in SQL Server");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Exception during exporting to Sql Server");
                Console.WriteLine($"!!! Please check correctness connection string: {Environment.NewLine}   {connectionString}");
            }

            // export in CSV
            var fileName = "D:\\example12.csv";
            var hasHeader = true;
            var delimiter = ",";
            var comment = "#";
            var encoding = System.Text.Encoding.ASCII.EncodingName;
            var useQuotes = false;
            var csvSettings = new Text(fileName, hasHeader, delimiter, comment, encoding, useQuotes);

            var exportSettings = new DataMatch.Api.Export.ExportSettings(
                sourceDb: SourceDb.CSV,
                schemaName: "",
                tableName: "",
                dropTable: true,
                truncate: false,
                bulkCopy: false);

            DataMatch.Api.Export.DataExportHelper.Export(projectInfo.MatchEngine.FinalScoresGroupsTable, csvSettings, exportSettings, onTableProgress: null);
            Console.WriteLine("groups exported in CSV");

            Console.WriteLine($"{Environment.NewLine}Press Enter to continue . . .");
            Console.ReadLine();
        }
    }
}