﻿using dataladder.Licensing;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SdkInterface
{
    public class ApiSettings
    {
        static readonly ILog Log = LogManager.GetLogger(nameof(ApiSettings));

        public static void Init(String settingsFilePath)
        {
            //dataladder.Matching.ApplicationSettings.Load();
            dataladder.Matching.ApplicationSettings.ReadAndValidateSettings(settingsFilePath);
            //Log.Debug(dataladder.Matching.ApplicationSettings.GetSettingsAsText());
            var _registration = new RegistrationWrapper();
        }
    }

    public class ApiRegistration
    {
        private RegistrationWrapper _registration;
        
        public DateTime ExpirationDate => RegistrationWrapper.ExpirationDate;

        public Boolean IsRegistered => Registration.Registered;
        public Boolean IsApi => Registration.IsDmeApi;
        public Boolean UseAdressVerification => Registration.UseAdressVerification;
        public Boolean IsAddressVerification => Registration.IsAddressVerification;
        public Boolean IsAvFoldersNotFound => Registration.IsAvFoldersNotFound;
        public Boolean IsAvExpired => Registration.IsAvExpired;
        public Boolean IsServer => Registration.IsServer;

        public ApiRegistration()
        {
            _registration = new RegistrationWrapper();
        }
    }
}
