﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Windows.Forms;

namespace UsingTheExistingProjectWithGUI
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            AppDomain.CurrentDomain.AssemblyResolve += CurrentDomain_AssemblyResolve;
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new MainForm());
        }

        private static readonly List<String> AccuZipAssemblyNames = new List<String> { "AccuAddress.dll", "log4net.dll" };

        private static System.Reflection.Assembly CurrentDomain_AssemblyResolve(Object sender, ResolveEventArgs args)
        {
            String assemblyName = args.Name.Split(new[] { ',' }, 2)[0] + ".dll";
            String archSpecificPath = System.IO.Path.Combine(AppDomain.CurrentDomain.SetupInformation.ApplicationBase, assemblyName);
            Boolean fileExists = System.IO.File.Exists(archSpecificPath);
            Boolean nameIsValid = AccuZipAssemblyNames.Contains(assemblyName);
            Assembly assembly = null;
            if (fileExists && nameIsValid)
            {
                assembly = Assembly.LoadFile(archSpecificPath);
            }
            return assembly;
        }
    }
}
