﻿using AddressValidation.Backend;
using AddressValidation.DataLayer.Entities;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;

namespace AddressValidationWebSample
{
    public class MatchingWorker
    {
        private RecordCleaner _cleaner;
        private List<String> _fieldNames;

        private DataTable _holdingTable;
        private DataTable _suppressedTable;
        private DataTable _masterTable;
        private String _processesCompleted;

        public DataTable HoldingTable => _holdingTable;
        public DataTable SuppressedTable => _suppressedTable;
        public DataTable MasterTable => _masterTable; 
        public String ProcessesCompleted => _processesCompleted; 
        public Boolean? IsLastInsertedRecordUnique => _cleaner.IsLastInsertedRecordUnique;

        private static MatchingWorker _worker;

        private MatchingWorker()
        {
            _cleaner = new RecordCleaner(ConfigurationManager.AppSettings["TransformationProject"], 
                                         ConfigurationManager.AppSettings["MatchingProject"],
                                         ConfigurationManager.AppSettings["SettingsFile"],
                                         ConfigurationManager.ConnectionStrings["ContactDataDbConnectionString"].ConnectionString
                                         );
            InitFieldNames();
            InitTables();
        }

        private void InitFieldNames()
        {
           _fieldNames = new List<String>
           {
                nameof(ContactInfo.FirstName),
                nameof(ContactInfo.LastName),
                nameof(ContactInfo.Address1),
                nameof(ContactInfo.Address2),
                nameof(ContactInfo.City),
                nameof(ContactInfo.State),
                nameof(ContactInfo.Zip),
                nameof(ContactInfo.Phone),
                nameof(ContactInfo.Email)
            };
        }

        private void InitTables()
        {
            _cleaner.InitHoldingTable(_fieldNames);

            _holdingTable = _cleaner.GetHoldingTable();
            _suppressedTable = _cleaner.GetSuppresedTable();
            _masterTable = _cleaner.GetMasterTable();
        }

        public static MatchingWorker Instance
        {
            get
            {
                if (_worker == null)
                {
                    _worker = new MatchingWorker();
                }
                return _worker;
            }
        }

        public void AnalyzeRecord(ContactInfo contactInfo)
        {
            String[] values =
            {
                contactInfo.FirstName,
                contactInfo.LastName,
                contactInfo.Address1,
                contactInfo.Address2,
                contactInfo.City,
                contactInfo.State,
                contactInfo.Zip,
                contactInfo.Phone,
                contactInfo.Email
            };

            _cleaner.InsertRecords(values, _fieldNames.ToArray(),
                out _holdingTable,
                out DataTable transTable, out DataTable matchTable,
                out _masterTable,
                out _suppressedTable,
                out String[] msgs
                );

            StringBuilder sb = new StringBuilder();
            Array.ForEach(msgs, msg => sb.AppendLine(msg + "<br/>"));
            _processesCompleted = sb.ToString();
        }
    }
}