﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LiveSearchInThreeTables
{
    public partial class SettingsForm : Form
    {
        private string _project1;
        internal string Project1
        {
            get { return _project1; }
            set
            {
                _project1 = value;
                label4.Text = _project1;
            }
        }

        private string _project2;
        internal string Project2
        {
            get { return _project2; }
            set
            {
                _project2 = value;
                label5.Text = _project2;
            }
        }

        private bool _increaseSpeed;
        internal bool IncreaseSpeed
        {
            get { return _increaseSpeed; }
            set
            {
                _increaseSpeed = value;
                chBIncreaseSpeed.Checked = _increaseSpeed;
            }
        }

        private int _countRecords;
        internal int CountRecords
        {
            get { return _countRecords; }
            set
            {
                _countRecords = value;
                tbRecords.Text = _countRecords.ToString();
            }
        }

        private string _image;
        internal string ImagePath
        {
            get { return _image; }
            set
            {
                try
                {
                    pictureBox1.Image = System.Drawing.Image.FromFile(value);
                    //_mainView.PictureBoxLogo.Image = System.Drawing.Image.FromFile(value);

                    //_mainView.PictureBoxLogo.Height = _mainView.PictureBoxLogo.Image.Height;
                    //panel2.Height = pictureBoxPreview.Image.Height + 6;

                    pictureBox1.SizeMode = PictureBoxSizeMode.AutoSize;
                    _image = value;
                }
                catch { };
            }
        }

        internal bool PathesChanged = false;

        internal string NewDataPath = "";
        internal string NewTempDataPath = "";
        internal string NewProjectPath = "";

        public bool StopEngine { get; internal set; }

        public SettingsForm()
        {
            InitializeComponent();
            StopEngine = false;

            textBox1.Text = dataladder.Matching.ApplicationSettings.TempDataPath;
            textBox2.Text = dataladder.Matching.ApplicationSettings.DataPath;
            textBox3.Text = dataladder.Matching.ApplicationSettings.ProjectsPath;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (GetFile(out string tmp))
                Project1 = tmp;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (GetFile(out string tmp))
                Project2 = tmp;
        }

        bool GetFile(out string filename)
        {
            filename = "";
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "DME files (*.dmeproj)|*.dmeproj|All files (*.*)|*.*";
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                filename = ofd.FileName;
                return true;
            }
            return false;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Image files (*.bmp)|*.bmp|All files (*.*)|*.*";
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                ImagePath = ofd.FileName;
            }
        }

        private void bnStopEngine_Click(object sender, EventArgs e)
        {
            StopEngine = true;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (CheckPath(textBox1.Text))
                if (CheckPath(textBox2.Text))
                    if (CheckPath(textBox3.Text))
                    {
                        NewTempDataPath = textBox1.Text;
                        NewDataPath = textBox2.Text;
                        NewProjectPath = textBox3.Text;
                        PathesChanged = true;
                    }
        }

        private bool CheckPath(string path)
        {
            if (System.IO.Directory.Exists(path))
                return true;
            MessageBox.Show($"Directory '{path}' does not exist. Paths were not saved");
            return false;
        }

        private void tbRecords_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (Int32.TryParse(tbRecords.SelectedItem + "", out int num))
            {
                CountRecords = num;
            }
        }

        private void chBIncreaseSpeed_CheckedChanged(object sender, EventArgs e)
        {
            IncreaseSpeed = chBIncreaseSpeed.Checked;
        }
    }
}
