﻿using System.Runtime.Serialization;
using System.ServiceModel;
using System.Data;

namespace SampleServiceNamespace
{
  [ServiceContract]
  public interface ISampleService
  {
        /// <summary>
        /// returns all matches as strings
        /// first element contains the number of columns (colCount)
        /// next colCount elements are the returned field names
        /// all other elements are the scores and field values from the returned results
        /// </summary>
        /// <param name="hash">calculated from the table name and values</param>
        /// <param name="tableName">Name of the table.</param>
        /// <param name="values">The values.</param>
        /// <param name="records">the max number of matching records to return</param>
        /// <returns></returns>
        [OperationContract]
    string[] GetMatches(string hash, string tableName, string[] values, int records);

    /// <summary>
    /// returns all matching fields from the project
    /// </summary>
    /// <param name="hash">calculated from the table name</param>
    /// <param name="tableName">Name of the table.</param>
    /// <returns></returns>
    [OperationContract]
    string[] GetMatchingFields(string hash, string tableName);

    /// <summary>
    /// Loads the project
    /// </summary>
    /// <param name="hash">calculated from the table name</param>
    /// <param name="tableName">Name of the table.</param>
    /// <returns></returns>
    [OperationContract]
    bool Init(string hash, string tableName, bool useLog = false, bool doTransformation = false);

    /// <summary>
    /// determine if project is loaded and running
    /// </summary>
    /// <param name="hash">calculated from the table name</param>
    /// <param name="tableName">Name of the table.</param>
    /// <returns>
    ///   <c>true</c> if the specified project is running; otherwise, <c>false</c>.
    /// </returns>
    [OperationContract]
    bool IsRunning(string hash, string tableName);

    /// <summary>
    /// unloads specific project from the service
    /// </summary>
    /// <param name="hash">calculated from the table name</param>
    /// <param name="tableName">Name of the table.</param>
    /// <returns></returns>
    [OperationContract]
    bool Unload(string hash, string tableName);

    /// <summary>
    /// insert record
    /// </summary>
    /// <param name="hash">calculated from the table name and values</param>
    /// <param name="tableName">Name of the table.</param>
    /// <param name="values">values for the new record</param>
    /// <param name="error">The error.</param>
    /// <returns></returns>
    [OperationContract]
    bool InsertRecord(string hash, string tableName, string[] fields, string[] values, out string[] inserted, out string error);

    /// <summary>
    /// update an existing record
    /// </summary>
    /// <param name="hash">calculated from the table name and values</param>
    /// <param name="tableName">Name of the table.</param>
    /// <param name="values">The values.</param>
    /// <param name="id">id is the primary key, for now it is designed that our tables have one field called id as primary key</param>
    /// <param name="error">The error.</param>
    /// <returns></returns>
    [OperationContract]
    bool UpdateRecord(string hash, string tableName, string[] values, string id, out string error);

    /// <summary>
    /// delete an existing record
    /// </summary>
    /// <param name="hash">calculated from the table name</param>
    /// <param name="tableName">Name of the table.</param>
    /// <param name="id">id is the primary key, for now it is designed that our tables have one field called id as primary key</param>
    /// <param name="error">The error.</param>
    /// <returns></returns>
    [OperationContract]
    bool DeleteRecord(string hash, string tableName, string id, out string error);

    [OperationContract]
    string GetCommonName(string firstname);

    [OperationContract]
    bool ChangeThresholds(string hash, string tableName, int high, int low, out string error);

  }
}