﻿using System;

using dataladder.Data;
using dataladder.Licensing;
using dataladder.Matching.Project;

namespace UsingTheExistingProject
{
    class Program
    {
        #region Fields


        #endregion

        static void Main(string[] args)
        {
            RegistrationWrapper registrationWrapper = new RegistrationWrapper();
            registrationWrapper.CustomPathForRegistrationFile = @"D:\API\registration\";
            DateTime expirationTime = RegistrationWrapper.ExpirationDate;
            Console.WriteLine("Expiration time: " + expirationTime);

            dataladder.Matching.ApplicationSettings.DataPath = @"D:\API\data\";
            dataladder.Matching.ApplicationSettings.TempDataPath = @"D:\API\temp\";

            ProjectInfo projectInfo = new ProjectInfo();
            //projectInfo.Load(@"D:\API\projects\ApiExampleCsv.dmeproj"); 
            projectInfo.Load(@"D:\API\projects\ApiExampleExcel.dmeproj");

            Console.WriteLine("project: \"" + projectInfo.ProjectName + "\" loaded.");
                       
            projectInfo.RunTransformation();
            Console.WriteLine("data transformed");
            projectInfo.MatchEngine.DoIndex();
            Console.WriteLine("indexing finished");
            projectInfo.MatchEngine.DoMatch();
            Console.WriteLine("matching finished");
            projectInfo.MatchEngine.ProcessFinalResults();
            Console.WriteLine("results processed");

            string connectionString = @"Data Source=localhost\SQLEXPRESS;Initial Catalog=API;Integrated Security=True";
            try
            {
                SqlDbHelper sqlDbHelper = new SqlDbHelper(connectionString);
                string exportTableName = projectInfo.ProjectName + " results";
                string schemaName = "dbo";
                bool truncate = sqlDbHelper.TableExists(schemaName, exportTableName);
                dataladder.Data.IReaderHelper.Export(projectInfo.MatchEngine.FinalScoresGroupsTable,
                    sqlDbHelper,
                    schemaName: "",
                    tableName: exportTableName,
                    onTableProgress: null,
                    bulkCopy: true,
                    truncate: truncate);
                Console.WriteLine("groups exported");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Exception during exporting to Sql Server");
                Console.WriteLine($"!!! Please check correctness connection string: {Environment.NewLine}   {connectionString}");
            }
            Console.WriteLine($"{Environment.NewLine}Press Enter to continue . . .");
            Console.ReadLine();
        }
    }
}