﻿using System.Collections.Generic;
using System.Data;

namespace AddressValidation.DataLayer.Entities
{
    public class ContactInfoHelper
    {
        public static ContactInfo CreateContactInfo(DataTable table, bool isDuplicate, bool isVerified)
        {
            var ci = new ContactInfo();

            ci.FirstName = Extract(table,"Common Name", "FirstName", "First Name");
            ci.LastName = Extract(table, "LastName", "Last Name");
            ci.Address1 = Extract(table, "V Primary Address", "Address1");
            ci.Address2 = Extract(table, "Address2", "V Secondary Address");
            ci.City = Extract(table, "V City", "City");
            ci.State = Extract(table, "V State", "State");
            ci.Zip = Extract(table, "V Zip Code", "Zip");
            ci.Country = Extract(table, "V Country", "Country");
            ci.Phone = Extract(table, "Phone");
            ci.Email = Extract(table, "Email");
            ci.Custom1 = Extract(table, "Custom1");
            ci.Custom2 = Extract(table, "Custom2");
            ci.IsDuplicate = isDuplicate;
            ci.IsVerified = isVerified;

            return ci;
        }

        /// <summary>
        ///  Extract from the first row of the table a value from a column 
        ///  that has less index in params
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="columnNames"></param>
        /// <returns></returns>
        private static string Extract(DataTable dt, params string[] columnNames)
        {
            if (dt.Rows.Count > 0)
            {
                foreach (var name in columnNames)
                {
                    if (dt.Columns.Contains(name))
                    {
                        return dt.Rows[0][name]?.ToString();
                    }
                }
            }
            return null;
        }

        public static DataTable ListContactInfoToDataTable(List<ContactInfo> list)
        {
            var res = new DataTable("Contacts");
            res.Columns.Add("FirstName", typeof(string));
            res.Columns.Add("LastName", typeof(string));
            res.Columns.Add("Address1", typeof(string));
            res.Columns.Add("Address2", typeof(string));
            res.Columns.Add("City", typeof(string));
            res.Columns.Add("State", typeof(string));
            res.Columns.Add("Zip", typeof(string));
            res.Columns.Add("Country", typeof(string));
            res.Columns.Add("Phone", typeof(string));
            res.Columns.Add("Email", typeof(string));
            res.Columns.Add("Custom1", typeof(string));
            res.Columns.Add("Custom2", typeof(string));
            res.Columns.Add("VerifiedAddress", typeof(string));

            foreach (var contact in list)
            {
                var row = res.NewRow();
                row["FirstName"] = contact.FirstName;
                row["LastName"] = contact.LastName;
                row["Address1"] = contact.Address1;
                row["Address2"] = contact.Address2;
                row["City"] = contact.City;
                row["State"] = contact.State;
                row["Zip"] = contact.Zip;
                row["Country"] = contact.Country;
                row["Phone"] = contact.Phone;
                row["Email"] = contact.Email;
                row["Custom1"] = contact.Custom1;
                row["Custom2"] = contact.Custom2;
                row["VerifiedAddress"] = contact.IsVerified;
                res.Rows.Add(row);
            }

            return res;
        }

        public static DataTable Normilize(DataTable table, bool verified =  false)
        {
            var ci = CreateContactInfo(table, false, false);
            ci.IsVerified = verified;
            return ListContactInfoToDataTable(new List<ContactInfo>() { ci });
        }
    }
}
