﻿using System;
using System.Text;
using DataMatch.AddressVerification.Contracts;

namespace DataMatch.AddressVerification.Extensions
{
    public static class CassResponseExtensions
    {
        private const String ColorOpenTag = "<color=\"{0}\">";
        private const String ColorCloseTag = "</color>";

        private const String BoldOpenTag = "<b>";
        private const String BoldCloseTag = "</b>";

        /// <summary>
        /// Adds colorization to an address from the response.
        /// </summary>
        /// <param name="response"> Response with Primary Address. </param>
        /// <param name="input"> Input text to colorize </param>
        /// <returns> Input primary address with colorization tags. </returns>
        public static String ToHtml(this ICassResponse response, String input)
        {
            String address = response.AddressPrimary;
            StringBuilder sb = new StringBuilder(address.Length);

            sb.Append(BoldOpenTag);
            sb.Append(String.Format(ColorOpenTag, "gray"));

            Int32 startIndex = 0;
            Int32 index = -1;
            while ((index = address.IndexOf(input, startIndex, StringComparison.OrdinalIgnoreCase)) >= 0)
            {
                sb.Append(address.Substring(startIndex, index - startIndex));
                sb.Append(ColorCloseTag);
                sb.Append(String.Format(ColorOpenTag, "green"));
                sb.Append(input);
                sb.Append(ColorCloseTag);
                sb.Append(String.Format(ColorOpenTag, "gray"));
                //startIndex += index;
                //startIndex += input.Length;
                startIndex = index + input.Length;
            }

            sb.Append(address.Substring(startIndex, address.Length - startIndex));
            sb.Append(ColorCloseTag);
            sb.Append(BoldCloseTag);

            return sb.ToString();
        }
    }
}
