﻿using System;
using dataladder.Data;
using dataladder.Matching;
using log4net;

namespace Samples.AddressValidation.BL.Settings
{
    /* Class for keeping matching settings
     * */
    public class MatchingSettings
    {
        protected readonly ILog Log = LogManager.GetLogger(nameof(MatchingSettings));

        /// <summary>
        /// Working folder
        /// </summary>
        public String DataPath { get; set; }
        /// <summary>
        /// Folder for keeping intermediate results
        /// </summary>
        public String TempPath { get; set; }
        public String Name { get; set; }

        /// <summary>
        /// matching settings: definitions, criteria, mapping fields
        /// </summary>
        public MultipleMatchDefinitionsManager MatchDefinitionManager { get; set; }

        /// <summary>
        /// Storage for keeping data from database
        /// </summary>
        public OnDriveTable MasterOnDrive { get; set; }
        /// <summary>
        /// Storage for keeping data that were added in SQL table during working this app
        /// </summary>
        public OnDriveTable HoldingOnDrive { get; set; }
        /// <summary>
        /// Storage for keeping cleansing user input
        /// </summary>
        public OnDriveTable BufferOnDrive { get; set; }

        /// <summary>
        /// Hou many duplicates find for every request
        /// </summary>
        public Int32 MaxMatchesForOneRow { get; set; }
        public Int32 MaxMatchesPerGroup { get; set; }
        public Boolean AllRecordsInGoupMustBeSimilar { get; set; }
        /// <summary>
        /// Clean indexes and intermediate results after each search
        /// </summary>
        public Boolean ClearAllAfterMatching { get; set; }

        /// <summary>
        /// Creates instance
        /// </summary>
        /// <param name="dataPath">working folder</param>
        /// <param name="tempPath">folder for keeping intermediate results</param>
        /// <param name="name"></param>
        public MatchingSettings(String dataPath, String tempPath, String name)
            :this()
        {
            DataPath = dataPath;
            TempPath = tempPath;
            Name = name;

            Log.Debug("MATCHING SETTINGS LOADED:\n");
            Log.Debug(DataPath);
            Log.Debug(TempPath);
            Log.Debug(Name);
        }

        /// <summary>
        /// Create instance without defining working paths
        /// </summary>
        public MatchingSettings()
        {
            MaxMatchesForOneRow = 5;
            MaxMatchesPerGroup = 0;
            // This variable defines would we reindex all data sources before 
            // every matching or not.
            // If it is 'true' then speed of matching decreases significantly (in this app)
            ClearAllAfterMatching = false;
            AllRecordsInGoupMustBeSimilar = false;
        }
    }
}
