﻿using log4net;
using System;
using System.IO;
using System.Text;

namespace Samples.AddressValidation.BL.Settings
{
    /* This class keeps information about application folders,
     * connection strings etc.
     * This informations is read from app.config or web.config when method 
     * Load() is executing.
     * 
     * */
    public class GlobalSettings
    {
        private readonly ILog Log = LogManager.GetLogger(nameof(GlobalSettings));
        /// <summary>
        /// Where DataLadder license is kept
        /// </summary>
        public String LicensePath { get; private set; }
        /// <summary>
        /// Path to working folder where keeps internal storages, 
        /// inside which an 'uncomplete' folder is created
        /// </summary>
        public String DataPath { get; private set; }
        /// <summary>
        /// Path to main SDK folder.
        /// Inside this folder a various SDK applications create their 
        /// own working folders
        /// </summary>
        public String BaseDirectory { get; private set; }
        /// <summary>
        /// Name of subfolder.
        /// DataPath = BaseDirectory + WorkingSubFolder
        /// </summary>
        public String WorkingSubfolder { get; private set; }
        /// <summary>
        /// Folder for keeping intermediate results
        /// </summary>
        public String TempPath { get; private set; }
        /// <summary>
        /// Path to CASS database (C:\\enterpricse)
        /// </summary>
        public String AddressDbPath { get; private set; }
        /// <summary>
        /// Path to CASS geocoder database
        /// </summary>
        public String GeoDbPath { get; private set; }
        /// <summary>
        /// Connection string to database with master data
        /// </summary>
        public String ConnectionString { get; private set; }
        /// <summary>
        /// Table Name in the database
        /// </summary>
        public String DbTableName { get; private set; }
        /// <summary>
        /// Path to project that keeps transformation settings
        /// </summary>
        public String TransformationProjectPath { get; private set; }
        /// <summary>
        /// Path to project with matching settings
        /// </summary>
        public String MatchingProjectPath { get; private set; }
        /// <summary>
        /// Use settings from predefined projects. If false will be used 
        /// hardcoded fixed settings
        /// </summary>
        public Boolean UseProjects { get; private set; }

        public void Load()
        {
            LicensePath = Properties.Settings.Default.LicensePath;
            BaseDirectory = Properties.Settings.Default.DataPath;
            WorkingSubfolder = Properties.Settings.Default.WorkingDirectory;
            DataPath = Path.Combine(BaseDirectory, WorkingSubfolder);
            TempPath = Properties.Settings.Default.TempPath;
            AddressDbPath = Properties.Settings.Default.AddressDbPath;
            GeoDbPath = Properties.Settings.Default.GeoDbPath;
            ConnectionString = Properties.Settings.Default.DbConnectionString;
            DbTableName = Properties.Settings.Default.DbTableName;
            TransformationProjectPath = Properties.Settings.Default.TransformationProjectPath;
            MatchingProjectPath = Properties.Settings.Default.MatchingProjectPath;
            UseProjects = Properties.Settings.Default.UseProjects;

            LogSettingsInfo();
        }

        private void LogSettingsInfo()
        {
            StringBuilder sb = new StringBuilder("---> SETTINGS LOADED\n");
            sb.AppendLine($"{nameof(LicensePath)}: {LicensePath}");
            sb.AppendLine($"{nameof(BaseDirectory)}: {BaseDirectory}");
            sb.AppendLine($"{nameof(WorkingSubfolder)}: {WorkingSubfolder}");
            sb.AppendLine($"{nameof(DataPath)}: {DataPath}");
            sb.AppendLine($"{nameof(TempPath)}: {TempPath}");
            sb.AppendLine($"{nameof(AddressDbPath)}: {AddressDbPath}");
            sb.AppendLine($"{nameof(GeoDbPath)}: {GeoDbPath}");
            sb.AppendLine($"{nameof(ConnectionString)}: {ConnectionString}");
            sb.AppendLine($"{nameof(DbTableName)}: {DbTableName}");
            sb.AppendLine($"{nameof(TransformationProjectPath)}: {TransformationProjectPath}");
            sb.AppendLine($"{nameof(MatchingProjectPath)}: {MatchingProjectPath}");

            Log.Debug(sb.ToString());
        }
    }
}