﻿using dataladder.Data;
using System;
using log4net;
using Samples.AddressValidation.BL.Transformation;

namespace Samples.AddressValidation.BL.Tables
{
    /* Class for preparing and cleansing user input
     * It contains two internal storage - InputTable and CleanedTable
     * The first keeps a raw user input
     * The second keeps already cleansed input.
     * Data cleans and moves with external classes. Here data just keeps
     * 
     * */
    public class BufferTable : IDisposable
    {
        private static readonly ILog Log = LogManager.GetLogger(typeof(BufferTable));

        public const String InputTableName = "BufferTable";
        public const String CleanedTableName = "CleanedBuffer";
        public const Int32 SourceId = 1;
        
        /// <summary>
        /// Working folder 
        /// </summary>
        public String Path => _path;
        private String _path;
        /// <summary>
        /// Strorage for keeping raw user input
        /// </summary>
        public OnDriveTable InputTable => _inputTable;
        private OnDriveTable _inputTable;
        /// <summary>
        /// Storage for keeping cleansed user input
        /// </summary>
        public OnDriveTable CleanedTable => _cleanedTable;
        private OnDriveTable _cleanedTable;

        public BufferTable(String path)
        {
            _path = path;
            _inputTable = new OnDriveTable(_path, InputTableName);
            _cleanedTable = new OnDriveTable(_path, CleanedTableName);
        }

        /// <summary>
        /// Creates structure of tables
        /// </summary>
        /// <param name="masterTable"></param>
        /// <returns></returns>
        public Boolean Init(OnDriveTable masterTable)
        {
            Boolean result = false;

            try
            {
                _inputTable.ToDeleteFilesAfterClosing = true;
                _inputTable.Dispose();

                OnDriveTable bufferTable = OnDriveTable.CreateNewTableWithTheStructureOfExisting(masterTable, InputTableName, _path);

                for (Int32 i = 0; i < masterTable.ColumnCount; i++)
                {
                    bufferTable.SetData(null, 0, i);
                }

                _inputTable = bufferTable;

                result = true;
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }

            return result;
        }

        public void Dispose()
        {
            _inputTable.ToDeleteFilesAfterClosing = true;
            _inputTable.Dispose();
            _cleanedTable.ToDeleteFilesAfterClosing = true;
            _cleanedTable.Dispose();
        }
    }
}
