﻿using dataladder.Data;
using System;
using log4net;
using System.Linq;

namespace Samples.AddressValidation.BL.Tables
{
    /* Wrapper for keeping records that were added into SQL table.
     * 
     * This class is needed for increasing speed of working. With this class
     * we don't need reload master table after each adding
     * 
     * */
    public class HoldingTable: IDisposable
    {
        private static readonly ILog Log = LogManager.GetLogger(typeof(HoldingTable));

        public const String HoldingTableName = "HoldingTable";
        public const Int32 SourceId = 2;

        /// <summary>
        /// Working folder
        /// </summary>
        public String Path => _path;
        private String _path;

        /// <summary>
        /// Internal storage
        /// </summary>
        public OnDriveTable Table => _holdingTable;
        private OnDriveTable _holdingTable;

        public HoldingTable(String path)
        {
            _path = path;
            _holdingTable = new OnDriveTable(_path, HoldingTableName);
        }


        public Boolean Init(OnDriveTable example)
        {
            Boolean result = false;

            try
            {
                _holdingTable.ToDeleteFilesAfterClosing = true;
                _holdingTable.Dispose();

                OnDriveTable temp = OnDriveTable.CreateNewTableWithTheStructureOfExisting(example, HoldingTableName, _path);

                for (Int32 i = 0; i < example.ColumnCount; i++)
                {
                    temp.SetData(null, 0, i);
                }

                _holdingTable = temp;

                result = true;
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }

            return result;
        }

        /// <summary>
        /// Insert into internal storage a user input.
        /// Count of column names and inserted values must be same
        /// </summary>
        /// <param name="colNames">list of columns in which add record</param>
        /// <param name="values">values that will be inserted</param>
        public void InsertRecord(string[] colNames, string[] values)
        {
            if (colNames.Length != values.Length)
                throw new ArgumentException("Count of column names and inserted values must be same");

            _holdingTable.MakeWritable();

            int row = _holdingTable.RecordCount;
            var cols = _holdingTable.GetColumnNames();
            for (int i = 0; i < colNames.Length; i++)
            {
                if (cols.Contains(colNames[i]))
                {
                    _holdingTable.SetData(values[i], row, colNames[i]);
                }
            }
        }            

        public void Dispose()
        {
            _holdingTable.ToDeleteFilesAfterClosing = true;
            _holdingTable.Dispose();
        }
    }
}
