﻿using Samples.AddressValidation.BL;
using System;
using System.Data;
using System.Windows.Forms;

namespace Samples.AddressValidation.WinForm
{
    /// <summary>
    /// This simple application for demonsration how use 
    /// Samples.AddressValidation.BL
    /// </summary>
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            AddressCleaner.Current.Init();
        }

        // 'Insert record' handler
        private void button1_Click(object sender, EventArgs e)
        {
            //send an entered record to match engine wraper  
            AddressCleaner.Current.InsertRecords(
                //array of entered values
                new string[]
                {
                    FirstNameTextBox.Text, LastNameTextBox.Text, Address1TextBox.Text,
                    ZipTextBox.Text, CityTextBox.Text,
                    Address2TextBox.Text, phoneTextBox.Text,
                    customTextBox1.Text, customTextBox2.Text, emailTextBox.Text,
                },
                //array of column names (Count of entered values and count of column names must be same)
                new string[]
                {
                    "FirstName", "LastName", "Address1",
                    "Zip", "City",
                    "Address2",  "Phone",
                    "Custom2", "Custom1", "Email",
                },
                //returned values
                out DataTable history,
                out DataTable trans, out DataTable match, out DataTable master,
                out DataTable dupl,
                out string[] msgs);
            //show results in datagrids
            dataGridView1.DataSource = history;
            dataGridView2.DataSource = dupl;
            dataGridView3.DataSource = master;
            //show steps of executing
            listBox1.Items.Clear();
            if (msgs != null)
            {
                foreach (var item in msgs)
                {
                    listBox1.Items.Add(item);
                }
            }
        }
        //it is important dispose all resources
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            AddressCleaner.Current.Close();
        }

        // 'Reset' handler
        private void button2_Click(object sender, EventArgs e)
        {
            AddressCleaner.Current.Reset();
            //Refresh datagrids
            dataGridView1.DataSource = AddressCleaner.Current.GetHistoryTable();
            dataGridView2.DataSource = AddressCleaner.Current.GetSuppressedTable();
            dataGridView3.DataSource = AddressCleaner.Current.GetMasterTable();

        }
    }
}
