﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="Samples.AddressValidation.Web.Default" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">

    <title>DataMatch Enterprise API Demo
    </title>

    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro" rel="stylesheet" />
    <link rel="shortcut icon" href="Images/favicon.ico" type="image/x-icon" />

    <style>
        body {
            font-family: 'Source Sans Pro', Tahoma, Geneva, Verdana, sans-serif
        }

        #leadGenFormPopUp {
            font-family: 'Source Sans Pro', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #eaeaea;
            width: 700px;
        }

        .submitFormLabel {
            font-weight: bold;
        }

        td {
            padding: 10px;
        }

        table {
            border-collapse: collapse;
        }

        .centered {
            margin: auto;
            padding: 1rem;
        }

        .modalBackground {
            background-color: darkgray;
            opacity: 0.5;
        }

        .autocomplete_completionListElement {
            margin: 0px !important;
            z-index: 99999 !important;
            background-color: white;
            color: windowtext;
            border: buttonshadow;
            border-width: 1px;
            border-style: solid;
            cursor: default;
            overflow: auto;
            height: auto;
            text-align: left;
            left: 0px;
            list-style-type: none;
        }

        .autocomplete_highlightedListItem {
            z-index: 99999 !important;
            color: black;
            margin-left: -30px;
            padding: 1px;
            cursor: grab;
        }
        /* AutoComplete item */
        .autocomplete_listItem {
            z-index: 99999 !important;
            color: windowtext;
            padding: 1px;
            margin-left: -30px;
            cursor: grab;
        }

        .gvHeaderStyle th {
            padding: 10px;
            font-size: 18px;
            font-weight: 600;
            background-color: #043780;
            color: white;
        }

        .gvHeaderStyle a {
            color: black;
            text-decoration: none;
        }

        .gvStyle td, .gvStyle th {
            border: 2px solid white;
        }
    </style>
</head>

<body>


    <%--<div style="margin: auto; overflow: auto;">
        <span style="display: block; float: left;">
            <asp:Image ID="imgClient" runat="server"
                ImageUrl="Images\clientLogo.png" Height="100" />
        </span>
        <span style="display: block; float: right;">
            <asp:Image ID="imgDataLadder" runat="server"
                ImageUrl="Images\PoweredDataLadder.png" Height="100" />
        </span>
    </div>

    <div id="demoTitle" style="padding: 1rem; background-color: #efefef; text-align: center;">
        <asp:Label runat="server"
            Font-Size="X-Large" Font-Bold="true" ForeColor="#333333"
            Text="DataMatch Enterprise API Demo" />
    </div>--%>

    <div>
        <form id="LeadGenerationForm" runat="server">

            <asp:ScriptManager ID="mainScriptManager" runat="server"
                EnablePageMethods="true" />

            <div style="display: table; width: 100%;">
                <div style="display: table-header-group; height: 100px;">

                    <div style="display: table-cell; padding: 10px; width: 20%; vertical-align: top;">
                        <%--CLIENT LOGO--%>
                        <asp:Image ID="imgClient" runat="server" 
                            ImageUrl="\Images\YourLogo.png" Width="300" />

                        <div style="padding: 50px 0 0;">
                            <%--ADD BUTTON--%>
                            <span style="margin-right: 10px">
                                <asp:Button ID="btnAddRecord" runat="server"
                                    Height="35"
                                    Font-Names="Source Sans Pro" Font-Size="Medium" Font-Bold="true"
                                    BorderStyle="Solid" BorderColor="#043780"
                                    ForeColor="White" BackColor="#043780"
                                    Text="Insert New Record"
                                    OnClick="btnOpenPopUp_Click" /></span>
                            <%--RESET BUTTON--%>
                            <asp:Button ID="btnReset" runat="server"
                                Height="35" Visible="True"
                                Font-Names="Source Sans Pro" Font-Size="Medium" Font-Bold="true"
                                BorderStyle="Solid" BorderColor="#ff6666"
                                ForeColor="#ffffff" BackColor="#ff6666"
                                Text="Reset"
                                OnClick="btnReset_Click" />
                        </div>
                    </div>

                    <%--TITLE--%>
                    <div style="display: table-cell; text-align: center; vertical-align: middle">
                        <div style="padding: 20px;">
                            <asp:Label runat="server" Font-Size="26pt" Font-Bold="true"
                                Text="DataMatch Enterprise API Demo" />
                        </div>
                    </div>

                    <%--DME LOGO--%>
                    <div style="display: table-cell; padding: 10px; width: 20%;">
                        <asp:Image ID="imgDataLadder" runat="server" Style="float: right;"
                            ImageUrl="Images\DmeServerApiLogo.png"
                            Width="300" />
                    </div>
                </div>
            </div>

            <%--MAIN TABLES--%>
            <div style="margin: auto; padding: 10px;">
                <table id="mainTable" style="width: 100%; height: 800px; table-layout: fixed">
                    <tbody>
                        <%--HOLDING TABLE--%>
                        <tr>
                            <td style="vertical-align: top; background-color: dimgray;">

                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Holding"
                                        Font-Size="Larger" Font-Bold="true" ForeColor="White" />
                                </div>

                                <div style="overflow: auto; outline: 3px solid darkgray;">
                                    <asp:GridView ID="gvHolding" runat="server"
                                        Width="100%" BackColor="White" CssClass="gvStyle"
                                        ShowHeaderWhenEmpty="true"
                                        AllowPaging="true" PageSize="10"
                                        AllowSorting="false"
                                        OnPageIndexChanging="gv_PageIndexChanging">
                                        <AlternatingRowStyle BackColor="#eaeaea" />
                                        <HeaderStyle CssClass="gvHeaderStyle" />
                                        <PagerSettings Mode="NumericFirstLast" />
                                    </asp:GridView>
                                </div>
                            </td>
                        </tr>
                        <%--PROGRESS PANEL--%>
                        <tr>
                            <td style="vertical-align: top; padding: 10px;">
                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Processes Completed"
                                        Font-Size="Larger" Font-Bold="true" ForeColor="#333333" />
                                </div>
                                <div style="padding: 10px;">
                                    <asp:Label ID="lblProgress" runat="server"
                                        Font-Size="Medium" Font-Bold="true" />
                                </div>
                            </td>
                        </tr>
                        <%--SUPPRESSED TABLE--%>
                        <tr>
                            <td style="vertical-align: top; background-color: dimgray;">

                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Suppressed"
                                        Font-Size="Larger" Font-Bold="true" ForeColor="White" />
                                </div>

                                <div style="overflow: auto; outline: 3px solid red;">
                                    <asp:GridView ID="gvSuppressed" runat="server"
                                        Width="2200" BackColor="White" CssClass="gvStyle"
                                        Settings-HorizontalScrollBarMode="Auto"
                                        ShowHeaderWhenEmpty="true"
                                        AllowPaging="true" PageSize="10"
                                        AllowSorting="false" AutoGenerateColumns="false"
                                        OnPageIndexChanging="gv_PageIndexChanging">
                                        <AlternatingRowStyle BackColor="#eaeaea" />
                                        <PagerSettings Mode="NumericFirstLast" />
                                        <HeaderStyle CssClass="gvHeaderStyle" />
                                        <RowStyle Wrap="true" />
                                        <Columns>
                                            <asp:BoundField DataField="FirstName" HeaderText="First Name" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="CommonName" HeaderText="Common Name" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="LastName" HeaderText="Last Name" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="Address1" HeaderText="Primary Address" HeaderStyle-Width="300px" />
                                            <asp:BoundField DataField="Address2" HeaderText="Secondary Address" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="City" HeaderText="City" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="State" HeaderText="State" HeaderStyle-Width="50px" />
                                            <asp:BoundField DataField="Zip" HeaderText="Zip" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="Country" HeaderText="Country" HeaderStyle-Width="50px" />
                                            <asp:BoundField DataField="Phone" HeaderText="Phone" HeaderStyle-Width="200px" />
                                            <asp:BoundField DataField="Email" HeaderText="E-mail" HeaderStyle-Width="300px" />
                                            <asp:BoundField DataField="Custom1" HeaderText="Custom Field 1" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="Custom2" HeaderText="Custom Field 2" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="CreateTime" HeaderText="Created" HeaderStyle-Width="200px" />
                                            <asp:BoundField DataField="VerifiedAddress" HeaderText="Address Verified" HeaderStyle-Width="100px" />
                                        </Columns>
                                    </asp:GridView>
                                </div>
                            </td>
                        </tr>

                        <%--MASTER TABLE--%>
                        <tr>
                            <td style="vertical-align: top; background-color: dimgray;">

                                <div style="text-align: center; margin: 10px;">
                                    <asp:Label runat="server" Text="Master"
                                        Font-Size="Larger" Font-Bold="true" ForeColor="White" />
                                </div>

                                <div style="overflow: auto; outline: 3px solid #043780;">
                                    <asp:GridView ID="gvMaster" runat="server" BackColor="White"
                                        Width="2200" Settings-HorizontalScrollBarMode="Auto" CssClass="gvStyle"
                                        ShowHeaderWhenEmpty="true"
                                        AllowPaging="true" PageSize="10"
                                        AllowSorting="false"
                                        AutoGenerateColumns="false"
                                        BorderColor="White"
                                        OnPageIndexChanging="gv_PageIndexChanging">
                                        <AlternatingRowStyle BackColor="#eaeaea" />
                                        <PagerSettings Mode="NumericFirstLast" />
                                        <HeaderStyle CssClass="gvHeaderStyle" />
                                        <RowStyle Wrap="true" />
                                        <Columns>
                                            <asp:BoundField DataField="FirstName" HeaderText="First Name" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="CommonName" HeaderText="Common Name" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="LastName" HeaderText="Last Name" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="Address1" HeaderText="Primary Address" HeaderStyle-Width="300px" />
                                            <asp:BoundField DataField="Address2" HeaderText="Secondary Address" HeaderStyle-Width="150px" />
                                            <asp:BoundField DataField="City" HeaderText="City" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="State" HeaderText="State" HeaderStyle-Width="50px" />
                                            <asp:BoundField DataField="Zip" HeaderText="Zip" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="Country" HeaderText="Country" HeaderStyle-Width="50px" />
                                            <asp:BoundField DataField="Phone" HeaderText="Phone" HeaderStyle-Width="200px" />
                                            <asp:BoundField DataField="Email" HeaderText="E-mail" HeaderStyle-Width="300px" />
                                            <asp:BoundField DataField="Custom1" HeaderText="Custom Field 1" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="Custom2" HeaderText="Custom Field 2" HeaderStyle-Width="100px" />
                                            <asp:BoundField DataField="CreateTime" HeaderText="Created" HeaderStyle-Width="200px" />
                                            <asp:BoundField DataField="VerifiedAddress" HeaderText="Address Verified" HeaderStyle-Width="100px" />
                                        </Columns>
                                    </asp:GridView>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <asp:Label ID="lblHidden" runat="server" Text="" />

            <ajaxToolkit:ModalPopupExtender
                ID="ModalPopupExtender" runat="server"
                TargetControlID="lblHidden"
                PopupControlID="leadGenFormPopUp"
                BackgroundCssClass="modalBackground" />

            <%--LEAD GENERATION FORM--%>
            <div id="leadGenFormPopUp" class="centered" style="">

                <div style="display: table; width: 100%;">
                    <div style="display: table-header-group; height: 100px;">

                        <%--CLIENT LOGO--%>
                        <div style="display: table-cell; padding: 10px; width: 20%; vertical-align: top;">
                            <asp:Image ID="Image1" runat="server"
                                ImageUrl="Images\YourLogo.png" Width="150" />
                        </div>

                        <%--TITLE--%>
                        <div style="display: table-cell; text-align: center; vertical-align: middle">
                            <div style="padding: 20px;">
                                <asp:Label runat="server" Font-Size="Large" Font-Bold="true"
                                    Text="Enter Info" />
                            </div>
                        </div>

                        <%--DME LOGO--%>
                        <div style="display: table-cell; padding: 10px; width: 20%;">
                            <asp:Image ID="Image2" runat="server" Style="float: right;"
                                ImageUrl="Images\DmeServerApiLogo.png"
                                Width="150" />
                        </div>
                    </div>
                </div>

                <%-- <div style="text-align: center; margin: 10px 10px 30px 10px">
                    <asp:Label runat="server"
                        Font-Size="Large" Font-Bold="true"
                        ForeColor="#333333"
                        Text="Complete All the Fields" />
                </div>--%>

                <table style="margin: auto;">
                    <tbody>
                        <%--First/Last Name--%>
                        <tr>
                            <td class="submitFormLabel" style="width: 20%">
                                <asp:Label runat="server" Height="20" Text="First Name" />
                            </td>
                            <td style="width: 30%">
                                <asp:TextBox ID="firstNameTxt" runat="server" Height="20" />
                            </td>
                            <td class="submitFormLabel" style="width: 20%; padding-left: 30px">
                                <asp:Label runat="server" Height="20" Text="Last Name" />
                            </td>
                            <td style="width: 30%;">
                                <asp:TextBox ID="lastNameTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--Address 1--%>
                        <tr>
                            <td class="submitFormLabel">
                                <asp:Label runat="server" Height="20" Text="Address 1" />
                            </td>
                            <td colspan="3">
                                <asp:TextBox ID="addressTxt" runat="server" Height="20" Width="100%" />

                                <ajaxToolkit:AutoCompleteExtender ID="autoCompleteExtender" runat="server"
                                    TargetControlID="addressTxt"
                                    ServiceMethod="SearchAddresses"
                                    MinimumPrefixLength="2"
                                    CompletionInterval="100" EnableCaching="false" CompletionSetCount="5"
                                    FirstRowSelected="true"
                                    OnClientShown="PopupShown" OnClientItemSelected="ItemSelected" />
                            </td>
                        </tr>
                        <%--Address 2--%>
                        <tr>
                            <td class="submitFormLabel">
                                <asp:Label runat="server" Height="20" Text="Address 2" />
                            </td>
                            <td colspan="3">
                                <asp:TextBox ID="address2Txt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--City/State--%>
                        <tr>
                            <td class="submitFormLabel">
                                <asp:Label runat="server" Height="20" Text="City" />
                            </td>
                            <td>
                                <asp:TextBox ID="cityTxt" runat="server" Height="20" />
                            </td>
                            <td class="submitFormLabel" style="padding-left: 50px">
                                <asp:Label runat="server" Height="20" Text="State" />
                            </td>
                            <td>
                                <asp:TextBox ID="stateTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--Zip/Phone--%>
                        <tr>
                            <td class="submitFormLabel">
                                <asp:Label runat="server" Height="20" Text="Zip" />
                            </td>
                            <td>
                                <asp:TextBox ID="zipTxt" runat="server" Height="20" Text="00000" />
                            </td>
                            <td class="submitFormLabel" style="padding-left: 50px">
                                <asp:Label runat="server" Height="20" Text="Phone" />
                            </td>
                            <td>
                                <asp:TextBox ID="phoneTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                        <%--Email--%>
                        <tr>
                            <td class="submitFormLabel">
                                <asp:Label runat="server" Height="20" Text="Email" />
                            </td>
                            <td colspan="3">
                                <asp:TextBox ID="emailTxt" runat="server" Height="20" Width="100%" />
                            </td>
                        </tr>
                    </tbody>
                </table>

                <div class="centered" style="width: 500px;">
                    <table style="width: 100%;">
                        <tbody>
                            <tr>
                                <td style="padding-right: 20px">
                                    <asp:Button ID="insertBtn" runat="server"
                                        Width="100%" Height="50"
                                        BorderStyle="Solid"
                                        BackColor="#ff9900" BorderColor="#ff9900"
                                        ForeColor="White" Font-Size="Medium" Font-Bold="true"
                                        Text="Submit"
                                        OnClick="insertBtn_Click"
                                        UseSubmitBehavior="true" />
                                </td>
                                <td style="padding-left: 20px">
                                    <asp:Button ID="btnCancel" runat="server"
                                        Width="100%" Height="50"
                                        BorderStyle="Solid"
                                        BackColor="DimGray" BorderColor="DimGray"
                                        ForeColor="White" Font-Size="Medium" Font-Bold="true"
                                        Text="Cancel"
                                        OnClick="btnCancel_Click" />
                                </td>

                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </form>
    </div>
    <script type="text/javascript">
        function PopupShown(sender, args) {
            sender._popupBehavior._element.style.zIndex = 99999999;
        }
        function ItemSelected(sender, args) {
            var addresses = sender.get_completionList().childNodes;
            var element = sender.get_element();

            for (var i = 0; i < addresses.length; i++) {
                var address = addresses[i];

                if (address.innerHTML == element.value) {
                    var addressValues = address._value.split("|");
                    document.getElementById("addressTxt").value = addressValues[0];
                    document.getElementById("address2Txt").value = addressValues[1];
                    document.getElementById("cityTxt").value = addressValues[2];
                    document.getElementById("stateTxt").value = addressValues[3];

                    PageMethods.SearchAddress(addressValues[0], addressValues[1], addressValues[2], addressValues[3], onSuccess, onError);

                    function onSuccess(result) {
                        document.getElementById("zipTxt").value = result;
                    }

                    function onError(result) {
                        document.getElementById("zipTxt").value = "00000";
                    }
                }
            }
        }
    </script>
</body>
</html>
