﻿using DataMatch.AddressVerification;
using DataMatch.AddressVerification.Contracts;
using DataMatch.AddressVerification.Entities;
using Samples.AddressValidation.BL;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataMatch.AddressVerification.Enums;

namespace Samples.AddressValidation.Web
{
    public partial class Default : System.Web.UI.Page
    {
        private const String ZipDefaultValue = "00000";

        [System.Web.Script.Services.ScriptMethod]
        [System.Web.Services.WebMethod]
        public static List<String> SearchAddresses(string prefixText, int count)
        {
            var cassManager = CassManagerFactory.Create(CassManagerTypes.Custom);
            ICassRequest cassRequest = new CassRequest { Query = prefixText };
            var cassResponses = cassManager.GetAddressSuggestions(cassRequest).Responses;

            List<String> addressList = new List<string>();
            foreach (var response in cassResponses)
            {
                var html = $"{response.AddressPrimary}|{response.AddressSecondary}|{response.City}|{response.State}";
                var item = AjaxControlToolkit.AutoCompleteExtender.CreateAutoCompleteItem(response.AddressMain, html);
                addressList.Add(item);
            }

            return addressList;
        }

        [System.Web.Script.Services.ScriptMethod]
        [System.Web.Services.WebMethod]
        public static String SearchAddress(String address1, String address2, String city, String state)
        {
            ICassManager cassManager = CassManagerFactory.Create(CassManagerTypes.Custom);
            IAddressRequest addressRequest = new AddressRequest
            {
                Address1 = address1,
                Address2 = address2,
                City = city,
                State = state
            };
            IAddressResponse addressResponse = cassManager.ValidateAddress(addressRequest);
            return addressResponse.Zip;
        }

        private void BindData()
        {
            gvHolding.DataSource = AddressCleaner.Current.HoldingTable;
            gvSuppressed.DataSource = AddressCleaner.Current.SuppressedTable;
            gvMaster.DataSource = AddressCleaner.Current.MasterTable;
            lblProgress.Text = AddressCleaner.Current.CompletedStages;

            gvHolding.DataBind();
            gvSuppressed.DataBind();
            gvMaster.DataBind();

            //gvHolding.PageIndex = gvHolding.PageCount > 0 ? gvHolding.PageCount - 1 : 0;
            //gvSuppressed.PageIndex = gvSuppressed.PageCount > 0 ? gvSuppressed.PageCount - 1 : 0;
            //gvMaster.PageIndex = gvMaster.PageCount > 0 ? gvMaster.PageCount - 1 : 0;

            if (AddressCleaner.Current.IsLastInsertedRecordUnique.HasValue
                && AddressCleaner.Current.IsLastInsertedRecordUnique.Value
                && gvMaster.PageIndex == 0
                )
            {
                gvMaster.Rows[0].BackColor = System.Drawing.Color.Yellow;
            }
            if (AddressCleaner.Current.IsLastInsertedRecordUnique.HasValue
                && !AddressCleaner.Current.IsLastInsertedRecordUnique.Value
                && gvSuppressed.PageIndex == gvSuppressed.PageCount - 1
                )
            {
                gvSuppressed.Rows[0].BackColor = System.Drawing.Color.Yellow;
            }
        }

        private void ResetSubmitForm()
        {
            firstNameTxt.Text = String.Empty;
            lastNameTxt.Text = String.Empty;
            addressTxt.Text = String.Empty;
            address2Txt.Text = String.Empty;
            cityTxt.Text = String.Empty;
            stateTxt.Text = String.Empty;
            zipTxt.Text = ZipDefaultValue;
            phoneTxt.Text = String.Empty;
            emailTxt.Text = String.Empty;
        }

        protected void Page_Load(Object sender, EventArgs e)
        { 
            BindData();
        }

        protected void insertBtn_Click(Object sender, EventArgs e)
        {
            String[] values =
            {
                firstNameTxt.Text,
                lastNameTxt.Text,
                addressTxt.Text,
                address2Txt.Text,
                cityTxt.Text,
                stateTxt.Text,
                zipTxt.Text,
                phoneTxt.Text,
                emailTxt.Text
            };

            AddressCleaner.Current.AnalyzeRecord(values);
            BindData();
            ResetSubmitForm();

            gvHolding.PageIndex = 0;
            gvSuppressed.PageIndex = 0;
            gvMaster.PageIndex = 0;
            BindData();
        }

        protected void btnOpenPopUp_Click(Object sender, EventArgs e)
        {
            ModalPopupExtender.Show();
        }

        protected void btnCancel_Click(Object sender, EventArgs e)
        {
            ModalPopupExtender.Hide();
            ResetSubmitForm();
        }

        protected void statusTimer_Tick(Object sender, EventArgs e)
        {
        }

        protected void btnReset_Click(Object sender, EventArgs e)
        {
            AddressCleaner.Current.Reset();
            BindData();
        }

        protected void gv_PageIndexChanging(Object sender, GridViewPageEventArgs e)
        {
            if (sender is GridView gv)
            {
                gv.PageIndex = e.NewPageIndex;
                BindData();
            }
        }
    }
}