﻿using System;
using dataladder.Data;
using dataladder.Matching;

namespace Samples.Common.Matching
{
    /// <summary>
    /// Match engine wrapper.
    /// For searching duplicates user must create an instance of this class and call method FindMatches().
    /// During creating of this class user must send as parameter 'MatchSettings' this classcontains all needed 
    /// definition, rules for matching, also after matching this class will contain results
    /// </summary>
    public class MatchManager
    {
        private MatchSettings Settings { get; }

        /// <summary>
        /// Creates instance
        /// </summary>
        /// <param name="matchSettings">Definitions for matching, also storages for results</param>
        public MatchManager(MatchSettings matchSettings)
        {
            Settings = matchSettings;
        }

        /// <summary>
        /// Makes matching
        /// </summary>
        public void FindMatches()
        {
            MatchEngine matchEngine = new MatchEngine(Settings.MatchDefinitionManager, Settings.AllRecordsInGoupMustBeSimilar,
                Settings.TempPath, Settings.DataPath, Settings.Name);

            matchEngine.InputDataMapperDict.Clear();

            foreach (var table in Settings.Tables)
            {
                OnDriveTable sourceTable = table as OnDriveTable;

                if (sourceTable != null)
                {
                    sourceTable.PriorityForMemory = OnDriveTable.PrioritiesForMemory.Normal;
                }

                matchEngine.InputDataMapperDict.Add(table.Name, table);
            }

            matchEngine.DataSourceIndexPairList.Clear();
            Settings.SourcePairs?.ForEach(p => matchEngine.DataSourceIndexPairList.Add(p));

            matchEngine.DoIndex();
            matchEngine.DoMatch(Settings.MaxMatchesForOneRow, Settings.ClearAllAfterMatching, Settings.MaxMatchesPerGroup);
            matchEngine.ProcessFinalResults();

            String dataPath = matchEngine.DataPath;

            String pairsFileNameBase = matchEngine.PairsScoresTable.FileNameBase;
            String groupsFileNameBase = matchEngine.FinalScoresGroupsTable.FileNameBase;

            //String pairsFilePath = matchEngine.PairsScoresTable.FilesPath;
            //String groupsFilePath = matchEngine.FinalScoresGroupsTable.FilesPath;

            matchEngine.Dispose();

            Settings.PairsScoresTable = new OnDriveTable(dataPath, pairsFileNameBase);
            Settings.FinalScoresGroupsTable = new OnDriveTable(dataPath, groupsFileNameBase);

        }
    }
}
