﻿using System;
using System.Collections.Generic;
using dataladder.Data;
using dataladder.Matching;

namespace Samples.Common.Matching
{
    /// <summary>
    /// Class for keeping all necesary parts for matching.
    /// Here are kept: 
    /// - paths to working directories
    /// - links to data sources,
    /// - rules of matching: definitions, source pairs,settings
    /// - storages with results of matching
    /// </summary>
    public class MatchSettings
    {
        /// <summary>
        /// Creates instanse and fills all settings with emprty values.
        /// </summary>
        public MatchSettings()
        {
            SourcePairs = new List<MatchEngine.DataSourceIndexPair>();
            Tables = new List<ITable2CoordsMapper>();
            MaxMatchesForOneRow = 3;
            MaxMatchesPerGroup = 0;
            ClearAllAfterMatching = true;
            AllRecordsInGoupMustBeSimilar = false;
        }

        /// <summary>
        /// Path to working directory
        /// </summary>
        public String DataPath { get; set; }
        /// <summary>
        /// Path to directory where will be kept temporary results
        /// </summary>
        public String TempPath { get; set; }
        /// <summary>
        /// Name of subfolder that will be created in DataPath.
        /// In this folder all results and uncompleted results will be kept.
        /// So each instance of this class will work with 
        /// own folder (if 'Name' are different)
        /// </summary>
        public String Name { get; set; }

        /// <summary>
        /// Contains definitions, criteria, how map columns of tables
        /// </summary>
        public MultipleMatchDefinitionsManager MatchDefinitionManager { get; set; }
        /// <summary>
        /// Definitions which data source will be matched math other.
        /// Every definition contains two number A and B. This numbers describe an index of the
        /// data source from the list 'Tables' of this class
        /// </summary>
        public List<MatchEngine.DataSourceIndexPair> SourcePairs { get; set; }
        /// <summary>
        /// List of data sources
        /// </summary>
        public List<ITable2CoordsMapper> Tables { get; set; }

        /// <summary>
        /// Max count of records that can be similar to separate record
        /// (By default 3)
        /// </summary>
        public Int32 MaxMatchesForOneRow { get; set; }
        /// <summary>
        /// How many duplicates can contain one group
        /// If it is 0 - limitation is absent
        /// (By defaul it is 0)
        /// </summary>
        public Int32 MaxMatchesPerGroup { get; set; }
        /// <summary>
        /// This property defines should all records in group must have the level 
        /// of similarity between each other more than criteria level.
        /// For example: 
        /// We have three tables: K, L, M.And we have two matching pairs K-L, L-M
        /// After matching(with level 90%) we get that some records in K-L have similarity 91% and
        /// the same record from L have similarity 92% with a record from M
        /// But the similarity between records from K and M is 89%
        /// So this property defines these records will be placed in one group or different.
        /// If it will be 'true' - then one group will be created and all 
        /// three records from K, M, L will be placed inside
        /// If it will be 'false' - then two groups will be created and in 
        /// first will be placed K, L records, and in the second group will 
        /// be placed the same record from L and record from M
        /// </summary>
        public Boolean AllRecordsInGoupMustBeSimilar { get; set; }
        /// <summary>
        /// Should match engine clear or intermediate results of indexing after matching
        /// By default - 'true'
        /// </summary>
        public Boolean ClearAllAfterMatching { get; set; }

        /// <summary>
        /// storage for keeping result of matching: matched pairs
        /// </summary>
        public OnDriveTable PairsScoresTable { get; set; }
        /// <summary>
        /// storage for keeping matching results: groups
        /// </summary>
        public OnDriveTable FinalScoresGroupsTable { get; set; }
    }

}
